const mongoose = require("mongoose")
const { ObjectId } = mongoose.Schema
 
const categorySchema = new mongoose.Schema({
    categories: {
        type: String,
        trim: true,
        required: true,
    },
    upload_thumbnail: {
        type: String
    },
    slug: {
        type: String,
    },
    totalsubCategory:{
        type: Number,      
    },

}, { timestamps: true });

const subCategory = new mongoose.Schema({

    title: {
        type: String,
        required: true,
        unique: true,
    },
    categoryId: {
        type: String,
        ref: 'category'
    },
    slug: {
        type: String,
    }
}, { timestamps: true });


const CategoryModel = mongoose.model("Category", categorySchema);
const SubCategoryModel = mongoose.model("subCategory", subCategory);

module.exports = {
    CategoryModel,
    SubCategoryModel
};