const express = require("express");
const router = express.Router();
const userController = require("../Controller/UserController");
const {verifyAdmin, verifyToken} = require('../../Auth/verify');

//-------------------------------------------apis for users-------------------------------------//

// Handle requests to the root path
router.get('/', userController.hello);

// Handle role and phone number request for inserting
router.post('/addphone', userController.addPhone);

// Verify OTP
router.post('/verifyOtp', userController.verifyOtp);

// Insert full name and license
router.post('/userDetail', verifyToken, userController.userDetail);

// Insert user language
router.post('/userlanguage', verifyToken, userController.userlanguage);

// profile
router.post('/profileUpdate', verifyToken, userController.profileUpdate);

//-------------------------------------------apis for Admin-------------------------------------//
//admin login...
router.post('/adminlogin', userController.adminLogin);

//fetch users
router.get('/users',verifyAdmin, userController.fetchUser);

//update user details
router.post('/userUpdate',verifyAdmin, userController.UpdateUser);

//delete user details
router.post('/userDelete',verifyAdmin, userController.removeUser);


module.exports = router;
