// home.js

const express = require('express');
const router = express.Router();
const homeController = require("../Controller/homeController");
const {verifyAdmin, verifyToken} = require('../../Auth/verify');
const { getVideos,
        getChapters,
        addChapter,
        courses,
        addCourse, 
        updateCourse, 
        deleteCourse, 
        updateChapter, 
        deleteChapter,
        fetchChapter,
     } = require('../Controller/homeController');

 
//--------------Apis for users---------------------//

// Route to fetch videos
router.get('/fetchcourse', verifyToken, getVideos);

// Route to fetch chapters
router.get('/chapters', verifyToken, getChapters);

//----------------------Apis for Admin----------------------//
//fetching courses
router.get('/courses',verifyAdmin, courses);

//for inserting course
router.post('/addCourse',verifyAdmin, addCourse);

//for update course
router.post('/updateCourse',verifyAdmin, updateCourse);

//for delete course
router.post('/deleteCourse',verifyAdmin, deleteCourse);

//for fetch chapters...
router.get('/fetchChapters',verifyAdmin, fetchChapter);

//for inserting chapters...
router.post('/addChapters',verifyAdmin, addChapter);

//for update chapters...
router.post('/updateChapters',verifyAdmin, updateChapter);

//for delete chapters...
router.post('/deleteChapters',verifyAdmin, deleteChapter);

module.exports = router; 
