const {CategoryModel, SubCategoryModel} = require("../model/categoryModel");
const multer = require('multer');
const fs = require('fs');
const path = require('path');
 
//that api for users
const listCategories = async (req, res) => {

    try {
        const categories = await CategoryModel.find();
        res.status(200).json({
            success: true,
            data: categories,
            message: "Categories fetched successfully"
        });
    } catch (error) {
        console.error("Error fetching categories:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error"
        });
    } 
};  

//that api for admin

const fetchCategory = async (req, res) => {
    try {
        // Fetch all categories and subcategories
        const categories = await CategoryModel.find();
        res.status(200).json({
            success: true,
            categories: categories,
        });
    } catch (error) {
        console.error("Error fetching Categories:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error",
        });
    }
};

//fetch subcategories
const fetchSubCategory = async (req, res)=>{
    try {
        categoryId = req.query.categoryId;
        console.log(categoryId);
        const subcategories = await SubCategoryModel.find({ categoryId });

        res.status(200).json({
            success: true,
            Subcategories: subcategories,
        });
    } catch (error) {
        console.error("Error fetching Subcategories:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error",
        });
    }
}

const createCategory = async (req, res) => {
    const upload = multer({
        storage: multer.diskStorage({
            destination: function (req, file, cb) {
                const categoryFolder = req.body.categories.replace(/\s+/g, '_'); 
                const userUploadPath = path.join('public', 'Upload_Category', categoryFolder);
                fs.mkdirSync(userUploadPath, { recursive: true });
                cb(null, userUploadPath);
            },
            filename: function (req, file, cb) {
                const ext = path.extname(file.originalname);
                cb(null, file.fieldname + '-' + Date.now() + ext);
            },
        }),
    });

    const fields = [
        { name: 'Upload_Category', maxCount: 1 }
    ];

    upload.fields(fields)(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const upload_thumbnail = req.files['Upload_Category'] ? req.files['Upload_Category'][0].filename : null;

        const categoryDetails = {
            categories: req.body.categories,
            totalsubCategory: req.body.totalsubCategory,
            upload_thumbnail,
            slug: req.body.categories,
        };

        try {
            await CategoryModel.create(categoryDetails);
            console.log("Category Created Successfully");
            res.status(200).send("Category Created Successfully");
        } catch (error) {
            console.error("Error processing Category create:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};


function getFolderName(fieldName) {
    switch (fieldName) {
        case 'Upload_Category':
            return 'Upload_Category';
        default:
            return ''; 
    }
};

const categoryUpdate = async (req, res)=>{
    
    const upload = multer({
        storage: multer.diskStorage({
            destination: function (req, file, cb) {
                const categoryFolder = req.body.categories.replace(/\s+/g, '_'); 
                const userUploadPath = path.join('public', 'Upload_Category', categoryFolder);
                fs.mkdirSync(userUploadPath, { recursive: true });
                cb(null, userUploadPath);
            },
            filename: function (req, file, cb) {
                const ext = path.extname(file.originalname);
                cb(null, file.fieldname + '-' + Date.now() + ext);
            },
        }),
    });

    const fields = [
        { name: 'Upload_Category', maxCount: 1 }
    ];

    upload.fields(fields)(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const upload_thumbnail = req.files['Upload_Category'] ? req.files['Upload_Category'][0].filename : null;

        const categoryDetails = {
            categories: req.body.categories,
            totalsubCategory: req.body.totalsubCategory,
            subCategories: req.body.subCategories,
            upload_thumbnail,
        };
        const categoryId = req.body.id;
        console.log(categoryId);

        try {
            const updatedcategory = await CategoryModel.findByIdAndUpdate(categoryId, categoryDetails);
            if(updatedcategory){
                console.log("Category Updated Successfully");
                res.status(200).send("Category Updated Successfully");
            }else{
                console.error("Category not found with ID:", userId);
                res.status(404).send("Category not found");
            }
        } catch (error) {
            console.error("Error processing Category Update:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};

const categoryRemove = async (req, res)=>{

        const categoryId = req.body.id;
        console.log(categoryId);
        try{
            const deleteCategory = await CategoryModel.deleteOne({ _id: categoryId });
            console.log(deleteCategory);
            if(deleteCategory){
                console.log("Category Delete Successfully");
                res.status(200).send("Category Delete Successfully");
            }else{
                console.error("Category not found with ID:", userId);
                res.status(404).send("Category not found");
            }
        }catch(error){
            console.error("Error processing Category Delete:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }

};

//inserting addSubcategory

const addSubcategory = async (req, res)=>{
    const subcategory = {
        title: req.body.subcategoryName,
        slug: req.body.subcategoryName,
        categoryId: req.body.categoryId
    };

    try{
        await SubCategoryModel.create(subcategory);
        console.log("SubCategory Added successfully");
        res.status(200).send("SubCategory Added Successfully");
    }catch(error){
        console.error("Error processing SubCategory add:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

//update subcategory
const updateSubcategory = async (req, res)=>{

    const subcategory = {
        title: req.body.subcategoryName,
        slug: req.body.subcategoryName,
        categoryId: req.body.categoryId
    };

    const subcategoryId = req.body.subcategoryId;

    try{
        await SubCategoryModel.findByIdAndUpdate(subcategoryId, subcategory);
        console.log("SubCategory Added successfully");
        res.status(200).send("SubCategory Added Successfully");
    }catch(error){
        console.error("Error processing SubCategory add:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

//delete subcategory
const deleteSubcategory = async (req, res)=>{
    const subcategoryId = req.body.id;
    console.log(subcategoryId);
    try{
        const deletesubCategory = await SubCategoryModel.deleteOne({ _id: subcategoryId });
       // console.log(deletesubCategory);
        if(deletesubCategory){
            console.log("subCategory Delete Successfully");
            res.status(200).send("subCategory Delete Successfully");
        }else{
            console.error("subCategory not found with ID:", userId);
            res.status(404).send("subCategory not found");
        }
    }catch(error){
        console.error("Error processing subCategory Delete:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
}

module.exports = {
    listCategories,
    createCategory,
    categoryUpdate,
    categoryRemove,
    fetchCategory,
    fetchSubCategory,
    addSubcategory,
    updateSubcategory,
    deleteSubcategory,
};