const jwt = require('jsonwebtoken');
const multer = require('multer');
const userModel = require('../model/userModel');
const fs = require('fs');
const path = require('path');
const util = require('util');

const hello = (req, res) => { 
    console.log("Reached hello controller");
    res.send("Hello from the controller!");
};

//-------apis for user pannel-----------//

const addPhone = async (req, res) => {
    console.log("Received data:", req.body);
 
    const { role, phone } = req.body;
    const otp = "1234"; // Set OTP to "1234"
 
    try {
        const existingUser =  await userModel.findOne({ mob_number: phone });

        if (existingUser) {
            // Mobile number already exists, update the OTP
            await userModel.updateOne({ mob_number: phone }, { mobile_otp: otp });
            res.status(200).json({ message: "Mobile number exists, OTP updated successfully!", otp });
        } else {
            // Mobile number doesn't exist, insert new record
            await userModel.create({ role, mob_number: phone, mobile_otp: otp });
            res.status(200).json({ message: "Phone number and role added successfully!", otp });
        }
    } catch (error) {
        console.error("Error in addPhone:", error);
        res.status(500).send("Internal Server Error");
    }
};

const generateOTP = () => {
    return Math.floor(1000 + Math.random() * 9000).toString();
};

const verifyOtp = async (req, res) => {
    console.log("Received data:", req.body);

    const { phone, otp } = req.body;

    try {
        const user = await userModel.findOne({ mob_number: phone, mobile_otp: otp });

        if (user) {
            console.log("OTP verified successfully!");

            const accessToken = jwt.sign({ userId: user._id }, process.env.JWT|| '1234abcd');
            await userModel.updateOne({ _id: user.userId }, { access_token: accessToken });

            console.log("Access token generated and stored successfully!");
            res.status(200).json({ accessToken });
        } else {
            console.log("Invalid OTP!");
            res.status(400).send("Invalid OTP");
        }
    } catch (error) {
        console.error("Error in verifyOtp:", error);
        res.status(500).send("Internal Server Error");
    }
};

const upload = multer({storage: multer.diskStorage({
    destination: function (req, file, cb) {
        const userId = req.user.userId;
        const userUploadPath = path.join('public/license_upload', userId.toString());
 
        // Create the user's folder if it doesn't exist
        fs.mkdirSync(userUploadPath, { recursive: true });
 
        cb(null, userUploadPath);
    },
    filename: function (req, file, cb) {
        const ext = path.extname(file.originalname);
        cb(null, file.fieldname + '-' + Date.now() + ext);
    }
})
});

const userDetail = async (req, res) => {
    const userId = req.user.userId;
    upload.single('upload_license')(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading license file:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading license file:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const upload_license = req.file ? req.file.filename : null;
        const { fullname, license_num } = req.body;

        try {
           // await userModel.userDetailUpdate(userId, fullname, license_num, upload_license);
            await userModel.updateOne({ _id: userId }, { fullname, license_num, upload_license });
            console.log("Full name, license_num, upload_license added successfully!");
            res.status(200).send("User details updated successfully!");
        } catch (error) {
            console.error("Error updating user details:", error);
            res.status(500).send("Internal Server Error");
        }
    });
};

const userlanguage = async (req, res) => {
    try {
        const { language } = req.body;
        const userId = req.user.userId;

        // Update user language using Mongoose
        const updatedUser = await userModel.findByIdAndUpdate(userId, { language });

        if (updatedUser) {
            console.log("Language updated successfully!");
            res.status(200).send("Language updated successfully!");
        } else {
            console.error("User not found");
            res.status(404).send("User not found");
        }
    } catch (error) {
        console.error("Error updating language:", error);
        res.status(500).send("Internal Server Error");
    }
};

const profileUpdate = async (req, res) => {
    const userId = req.user.userId;

    const upload = multer({
        storage: multer.diskStorage({
            destination: function (req, file, cb) {
                const folder = getFolderName(file.fieldname);
                const userUploadPath = path.join('public', folder, userId.toString());
                fs.mkdirSync(userUploadPath, { recursive: true });
                cb(null, userUploadPath);
            },
            filename: function (req, file, cb) {
                const ext = path.extname(file.originalname);
                cb(null, file.fieldname + '-' + Date.now() + ext);
            },
        }),
    });

    // Define the fields you expect to be uploaded
    const fields = [
        { name: 'upload_license', maxCount: 1 },
        { name: 'upload_aadhar', maxCount: 1 },
        { name: 'upload_profile', maxCount: 1 },
    ];

    // Use upload.fields middleware to handle multiple file fields
    upload.fields(fields)(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading files:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        // Access uploaded files using req.files
        const upload_license = req.files['upload_license'] ? req.files['upload_license'][0].filename : null;
        const upload_aadhar = req.files['upload_aadhar'] ? req.files['upload_aadhar'][0].filename : null;
        const upload_profile = req.files['upload_profile'] ? req.files['upload_profile'][0].filename : null;

        // Combine uploaded file names with other profile data
        const profileData = {
            fullname: req.body.fullname,
            license_num: req.body.license_num,
            mob_number: req.body.mob_number,
            email: req.body.email,
            aadhar_num: req.body.aadhar_num,
            upload_license,
            upload_aadhar,
            upload_profile,
        };

        try {
            // Update user profile using Mongoose
            const updatedUser = await userModel.findByIdAndUpdate(userId, profileData);

            if (updatedUser) {
                console.log("User profile updated successfully!");
                res.status(200).send("User profile updated successfully!");
            } else {
                console.error("User not found with ID:", userId);
                res.status(404).send("User not found");
            }
        } catch (error) {
            console.error("Error processing user profile update:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};

// Helper function to determine the folder based on the field name
function getFolderName(fieldName) {
    switch (fieldName) {
        case 'upload_license':
            return 'license_upload';
        case 'upload_aadhar':
            return 'aadhar_upload';
        case 'upload_profile':
            return 'profile_upload';
        default:
            return 'other_upload';
    }
}

//-------apis for admin pannel-----------//

const adminLogin = async (req, res)=>{

    try {
        const { email, password } = req.body;
    
        const admin = await userModel.findOne({ email });
    
        if (!admin) {
          return res.status(404).json({ error: 'Admin not found' });
        }

        if (admin.password !== password) {
            return res.status(401).json({ error: 'Invalid password' });
        }

        // Create and send JWT token
        const token = jwt.sign({ userId: admin._id, role: 'admin' }, 'advayaadmin@123', {
            expiresIn: '1d', // Adjust the expiration time as needed
        });
    
        res.json({ token });
      } catch (error) {
        console.error('Error during admin login:', error);
        res.status(500).json({ error: 'Internal Server Error' });
      }
};

const fetchUser = async (req, res)=>{
    try {
        // Assuming you have a Mongoose model for the "users" collection
        const users = await userModel.find();
        
        // Send the users as a response
        res.status(200).json({
            success: true,
            users: users
        });
    } catch (error) {
        console.error("Error fetching users:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error"
        });
    }
};

const UpdateUser = async (req, res)=>{

        const userDetails = {
            fullname: req.body.fullname,
            mob_number: req.body.mobile,
            email: req.body.email,
            role: req.body.role,
            aadhar_num: req.body.aadhar_num,
            license_num: req.body.license_num,
            course: req.body.course,
        };
        const userId = req.body.id;
        console.log(userId);

        try {
            const updatedUser = await userModel.findByIdAndUpdate(userId, userDetails);
            if(updatedUser){
                console.log("User Updated Successfully");
                res.status(200).send("User Updated Successfully");
            }else{
                console.error("User not found with ID:", userId);
                res.status(404).send("User not found");
            }
        } catch (error) {
            console.error("Error processing Category Update:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
};

const removeUser = async (req, res)=>{

        const userId = req.body.id;
        console.log(userId);
        try{
            const deleteUser = await userModel.deleteOne({ _id: userId });
            console.log(deleteUser);
            if(deleteUser){
                console.log("User Delete Successfully");
                res.status(200).send("User Delete Successfully");
            }else{
                console.error("User not found with ID:", userId);
                res.status(404).send("User not found");
            }
        }catch(error){
            console.error("Error processing User Delete:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }

};


module.exports = {
    hello,
    addPhone,
    verifyOtp,
    userDetail,
    userlanguage,
    profileUpdate,
    fetchUser,
    UpdateUser,
    removeUser,
    adminLogin
};
