const express = require("express");
const mongoose = require("mongoose");
const cors = require("cors");
const hostname = '127.0.0.1';
//console.log(process);
require('dotenv').config();

const port = process.env.PORT || 3000;
const Routes = require("./src/Routes/user");
const homeRoutes = require("./src/Routes/home");
const category = require('./src/Routes/category');
const quizRoutes = require('./src/Routes/Quiz');
const completeQuizRoutes = require('./src/Routes/completeQuiz');
const enrollmentRoutes = require('./src/Routes/enrollment');
const notificationRoutes = require('./src/Routes/notification');

const app = express();

// Middleware
app.use(express.urlencoded({ extended: false }));
app.use(express.json());
app.use(cors());
//console.log(process);
// MongoDB connection
mongoose.connect(process.env.MONGO_URI || "mongodb+srv://sanat:utlaMUlZfaZSLkTy@atlascluster.04z0zfa.mongodb.net/Advaya", {
   // useNewUrlParser: true,
   // useUnifiedTopology: true,
   // useCreateIndex: true,
}).then(() => {
    console.log('Connected to MongoDB');
}).catch((err) => {
    console.error('Error connecting to MongoDB:', err.message);
});
 
// Routes
app.use("/", Routes);
app.use('/homepage', homeRoutes);
app.use('/category', category);
app.use('/Quiz', quizRoutes);
app.use('/completeQuiz', completeQuizRoutes);
app.use('/enrollment', enrollmentRoutes);
app.use('/notification', notificationRoutes);
 
app.listen(port, hostname, () => {
  console.log(`Server running at http://${hostname}:${port}/`);
});
