"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactArborist = require("react-arborist");
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function TreeView(_ref) {
  var handleDeleteNode = _ref.handleDeleteNode,
    handleContextMenu = _ref.handleContextMenu,
    handleRenameNode = _ref.handleRenameNode,
    handleOnClick = _ref.handleOnClick,
    handleDoubleClick = _ref.handleDoubleClick,
    handleTripleClick = _ref.handleTripleClick,
    handleDragDrop = _ref.handleDragDrop,
    showRenameButton = _ref.showRenameButton,
    showRemoveButton = _ref.showRemoveButton,
    minTreeHeight = _ref.minTreeHeight,
    treeWidth = _ref.treeWidth,
    nodeHeight = _ref.nodeHeight,
    indent = _ref.indent,
    classes = _ref.classes,
    style = _ref.style,
    term = _ref.term,
    data = _ref.data,
    icons = _ref.icons,
    renameButton = _ref.renameButton,
    removeButton = _ref.removeButton,
    openByDefault = _ref.openByDefault,
    hoveredNodeId = _ref.hoveredNodeId,
    setHoveredNodeId = _ref.setHoveredNodeId,
    selectedNodeId = _ref.selectedNodeId,
    setSelectedNodeId = _ref.setSelectedNodeId,
    getCurrentNodeProps = _ref.getCurrentNodeProps,
    selection = _ref.selection;
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    calcTreeHeight = _useState2[0],
    setCalcTreeHeight = _useState2[1];
  var _useState3 = (0, _react.useState)(0),
    _useState4 = _slicedToArray(_useState3, 2),
    visibleNodesCount = _useState4[0],
    setVisibleNodesCount = _useState4[1];
  var clickCountRef = (0, _react.useRef)(0);
  var clickTimer = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    setCalcTreeHeight((visibleNodesCount + 1) * nodeHeight);
  }, [visibleNodesCount]);
  var handleClick = function handleClick(nodeProps) {
    var isSameNode = nodeProps.node.id === selectedNodeId;
    clickCountRef.current += 1;
    var handleAction = function handleAction(action, mode) {
      var handleBranch = function handleBranch() {
        return toggleInternalNodes(nodeProps, nodeProps.node.isOpen ? 'close' : 'open');
      };
      if (action === 'openAll') {
        handleBranch();
      } else if (action === 'rename') {
        nodeProps.node.edit();
      } else if (action) {
        if (action.changeNode) {
          action.changeNode(nodeProps);
        } else {
          nodeProps.node.isInternal ? nodeProps.node.toggle() : action(nodeProps);
        }
      } else if (mode === 'edit') {
        nodeProps.node.edit();
      } else if (mode === 'openAll') {
        handleBranch();
      } else {
        nodeProps.node.toggle();
      }
    };
    var resetClickCount = function resetClickCount() {
      clickCountRef.current = 0;
    };
    if (clickCountRef.current === (isSameNode ? 2 : 3)) {
      clickTimer.current = setTimeout(function () {
        handleAction(handleDoubleClick, 'openAll');
        resetClickCount();
      }, 300);
    }
    if (clickCountRef.current === (isSameNode ? 3 : 4) && handleRenameNode) {
      clearTimeout(clickTimer.current);
      handleAction(handleTripleClick, 'edit');
      resetClickCount();
    }
    if (clickCountRef.current === 1) {
      setTimeout(function () {
        if (clickCountRef.current === 1) {
          handleAction(handleOnClick);
        }
        resetClickCount();
      }, 400);
    }
    setTimeout(resetClickCount, 500);
  };
  var toggleInternalNodes = function toggleInternalNodes(nodeProps, action) {
    nodeProps.node.isInternal && (action === 'open' ? nodeProps.node.open() : nodeProps.node.close());
    if (nodeProps.node.children !== null) {
      nodeProps.node.children.forEach(function (child) {
        toggleInternalNodes({
          node: child,
          tree: nodeProps.tree
        }, action);
      });
    }
  };
  return /*#__PURE__*/_react["default"].createElement("div", {
    onClick: function onClick(e) {
      e.stopPropagation();
    },
    className: classes === null || classes === void 0 ? void 0 : classes.treeContainer,
    style: style === null || style === void 0 ? void 0 : style.treeContainer,
    onContextMenu: function onContextMenu(event) {
      handleContextMenu && event.preventDefault();
    }
  }, /*#__PURE__*/_react["default"].createElement(_reactArborist.Tree, {
    selection: selection,
    data: data,
    width: treeWidth,
    searchTerm: term,
    height: calcTreeHeight > minTreeHeight ? calcTreeHeight : minTreeHeight,
    openByDefault: openByDefault,
    rowHeight: nodeHeight,
    rowClassName: 'focus:outline-none',
    disableDrag: handleDragDrop !== null ? false : true,
    onMove: handleDragDrop,
    onDelete: handleDeleteNode,
    onContextMenu: handleContextMenu,
    searchMatch: function searchMatch(node, term) {
      return node.data.name.toLowerCase().includes(term.toLowerCase());
    }
  }, function (nodeProps) {
    var isFile = nodeProps.node.isLeaf;
    var isFolderOpen = nodeProps.node.isOpen;
    (0, _react.useEffect)(function () {
      setVisibleNodesCount(nodeProps.tree.visibleNodes.length);
    }, [nodeProps.tree.visibleNodes.length]);
    return /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.nodeContainer,
      style: style === null || style === void 0 ? void 0 : style.nodeContainer
    }, /*#__PURE__*/_react["default"].createElement("div", {
      ref: nodeProps.dragHandle,
      className: classes === null || classes === void 0 ? void 0 : classes.nodeWrapper,
      style: _objectSpread(_objectSpread({}, style === null || style === void 0 ? void 0 : style.nodeWrapper), {}, {
        marginLeft: "".concat(nodeProps.node.level * indent, "px"),
        backgroundColor: style !== null && style !== void 0 && style.nodeWrapper ? nodeProps.node.id === selectedNodeId ? style === null || style === void 0 ? void 0 : style.nodeWrapper.selectedColor : nodeProps.node.id === hoveredNodeId ? style === null || style === void 0 ? void 0 : style.nodeWrapper.hoveredColor : style === null || style === void 0 ? void 0 : style.nodeWrapper.backgroundColor : null
      }),
      onClick: function onClick() {
        handleClick(nodeProps);
        setSelectedNodeId(nodeProps.node.id);
      },
      onContextMenu: function onContextMenu(event) {
        handleContextMenu && event.preventDefault();
        nodeProps.node.select();
        nodeProps.node.tree.props.onContextMenu(event);
        getCurrentNodeProps(nodeProps);
      },
      onMouseOver: function onMouseOver() {
        setHoveredNodeId(nodeProps.node.id);
      },
      onMouseLeave: function onMouseLeave() {
        setHoveredNodeId(null);
      }
    }, /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.nodeTextBlock,
      style: _objectSpread(_objectSpread({}, style === null || style === void 0 ? void 0 : style.nodeTextBlock), {}, {
        display: 'flex',
        gap: '7px',
        zIndex: '10'
      })
    }, !isFile ? nodeProps.node.children.length > 0 ? /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement("span", null, isFolderOpen ? icons.arrowDown : icons.arrowRight), /*#__PURE__*/_react["default"].createElement("span", null, isFolderOpen ? icons.openFolder : icons.closeFolder)) : /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, isFolderOpen ? icons.openFolder : icons.closeFolder) : /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, icons.file), nodeProps.node.isEditing ? /*#__PURE__*/_react["default"].createElement("input", {
      type: "text",
      defaultValue: nodeProps.node.data.name,
      onFocus: function onFocus(e) {
        return e.currentTarget.select();
      },
      onBlur: function onBlur() {
        return nodeProps.node.reset();
      },
      onKeyDown: function onKeyDown(e) {
        if (e.key === 'Escape') nodeProps.node.reset();
        if (e.key === 'Enter') {
          nodeProps.node.submit(e.currentTarget.value);
          handleRenameNode(e.currentTarget.value, nodeProps.node.id);
        }
      },
      autoFocus: true,
      style: style === null || style === void 0 ? void 0 : style.renameInput,
      className: classes === null || classes === void 0 ? void 0 : classes.renameInput
    }) : /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.nodeText,
      style: style === null || style === void 0 ? void 0 : style.nodeText
    }, nodeProps.node.data.name)), /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.nodeButtonBlock,
      style: style === null || style === void 0 ? void 0 : style.nodeButtonBlock
    }, showRenameButton && /*#__PURE__*/_react["default"].createElement("button", {
      onClick: function onClick(e) {
        e.stopPropagation();
        nodeProps.node.edit();
      },
      title: renameButton.title,
      style: style === null || style === void 0 ? void 0 : style.renameButton,
      className: classes === null || classes === void 0 ? void 0 : classes.renameButton
    }, renameButton.content), showRemoveButton && /*#__PURE__*/_react["default"].createElement("button", {
      onClick: function onClick(e) {
        e.stopPropagation();
        nodeProps.tree["delete"](nodeProps.node.id);
      },
      title: removeButton.title,
      style: style === null || style === void 0 ? void 0 : style.removeButton,
      className: classes === null || classes === void 0 ? void 0 : classes.removeButton
    }, removeButton.content))));
  }));
}
TreeView.defaultProps = {
  selectedNodeId: '',
  selection: '',
  nodeHeight: 57,
  minTreeHeight: 400,
  treeWidth: 300,
  handleDeleteNode: function handleDeleteNode() {},
  getCurrentNodeProps: function getCurrentNodeProps() {},
  handleContextMenu: function handleContextMenu() {},
  setSelectedNodeId: function setSelectedNodeId() {},
  setHoveredNodeId: function setHoveredNodeId() {},
  handleRenameNode: null,
  handleDragDrop: null,
  hoveredNodeId: '',
  handleOnClick: null,
  handleDoubleClick: null,
  handleTripleClick: null,
  classes: {},
  openByDefault: true,
  style: {},
  data: [],
  term: '',
  indent: 20,
  icons: {
    file: '🗎',
    openFolder: '🗁',
    arrowDown: '⏷',
    arrowRight: '⏵',
    closeFolder: '🗀'
  },
  showRemoveButton: false,
  showRenameButton: false,
  removeButton: {
    content: '🗑️',
    title: 'Delete'
  },
  renameButton: {
    content: '✏️',
    title: 'Rename...'
  }
};
TreeView.propTypes = {
  /** An object with icons/symbols to display the node type */
  icons: _propTypes["default"].shape({
    file: _propTypes["default"].node,
    closeFolder: _propTypes["default"].node,
    openFolder: _propTypes["default"].node,
    arrowDown: _propTypes["default"].node,
    arrowRight: _propTypes["default"].node
  }),
  /** ID of the selected node */
  selectedNodeId: _propTypes["default"].string,
  /** Passing an id to the selection prop will select and scroll to that node whenever that id changes */
  selection: _propTypes["default"].string,
  /** Height of each node */
  nodeHeight: _propTypes["default"].number,
  /** Minimum tree window height */
  minTreeHeight: _propTypes["default"].number,
  /** If true, then all folders are open by default */
  openByDefault: _propTypes["default"].bool,
  /** Tree element deletion event handler function */
  handleDeleteNode: _propTypes["default"].func,
  /** Data for visual representation of hierarchy */
  data: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string,
    name: _propTypes["default"].string,
    children: _propTypes["default"].array
  })),
  /** Function to get properties of the current node */
  getCurrentNodeProps: _propTypes["default"].func,
  /** Context menu handler function */
  handleContextMenu: _propTypes["default"].func,
  /** Function to set the selected node */
  setSelectedNodeId: _propTypes["default"].func,
  /** Function to set hover node */
  setHoveredNodeId: _propTypes["default"].func,
  /** Node rename handler function */
  handleRenameNode: _propTypes["default"].func,
  /** Node drag handler function */
  handleDragDrop: _propTypes["default"].func,
  /** Hover node ID */
  hoveredNodeId: _propTypes["default"].string,
  /** Click handler function. By default, this is toggles the open/closed state of the folder. If you want to use the built-in function to rename or expand all nested elements, then pass a string with the corresponding 'rename' or 'openAll' values. If you want to pass a function that handles a node, whether it is a file or a folder, then you should provide the object with a "changeNode" function. */
  handleOnClick: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string, _propTypes["default"].shape({
    changeNode: _propTypes["default"].func
  })]),
  /** Double click handler function. By default, expands all children of a tree branch. If you want to use the built-in function to rename or expand all nested elements, then pass a string with the corresponding 'rename' or 'openAll' values. If you want to pass a function that handles a node, whether it is a file or a folder, then you should provide the object with a "changeNode" function. */
  handleDoubleClick: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string, _propTypes["default"].shape({
    changeNode: _propTypes["default"].func
  })]),
  /** Triple click handler function. By default, causes the node to be renamed if handleRenameNode is true. If you want to use the built-in function to rename or expand all nested elements, then pass a string with the corresponding 'rename' or 'openAll' values. If you want to pass a function that handles a node, whether it is a file or a folder, then you should provide the object with a "changeNode" function. */
  handleTripleClick: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string, _propTypes["default"].shape({
    changeNode: _propTypes["default"].func
  })]),
  /** Tree width */
  treeWidth: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  /** Class names for various elements */
  classes: _propTypes["default"].shape({
    /** Class for the container of the tree */
    treeContainer: _propTypes["default"].string,
    /** Class for a node in a tree */
    nodeWrapper: _propTypes["default"].string,
    /** Class for the text block of a node */
    nodeTextBlock: _propTypes["default"].string,
    /** Class for the input field when renaming */
    renameInput: _propTypes["default"].string,
    /** Class for the text of a node */
    nodeText: _propTypes["default"].string,
    /** Class for the button block of a node */
    nodeButtonBlock: _propTypes["default"].string,
    /** Class for the rename button */
    renameButton: _propTypes["default"].string,
    /** Class for the remove button */
    removeButton: _propTypes["default"].string
  }),
  /** Component styles */
  style: _propTypes["default"].shape({
    /** Styles for the container of the tree */
    treeContainer: _propTypes["default"].object,
    /** Style for a single node item with background colors for normal (backgroundColor), hover (hoveredColor), and selected (selectedColor) states. */
    nodeWrapper: _propTypes["default"].object,
    /** Styles for the text block of a node */
    nodeTextBlock: _propTypes["default"].object,
    /** Style for the input field when renaming */
    renameInput: _propTypes["default"].object,
    /** Styles for the text of a node */
    nodeText: _propTypes["default"].object,
    /** Styles for the button block of a node */
    nodeButtonBlock: _propTypes["default"].object,
    /** Style for the rename button */
    renameButton: _propTypes["default"].object,
    /** Style for the delete button */
    removeButton: _propTypes["default"].object
  }),
  /** Search query */
  term: _propTypes["default"].string,
  /** Indentation between nesting levels */
  indent: _propTypes["default"].number,
  /** Show delete button */
  showRemoveButton: _propTypes["default"].bool,
  /** Show rename button */
  showRenameButton: _propTypes["default"].bool,
  /** Delete button with content and title */
  removeButton: _propTypes["default"].shape({
    content: _propTypes["default"].node,
    title: _propTypes["default"].string
  }),
  /** Rename button with content and title */
  renameButton: _propTypes["default"].shape({
    content: _propTypes["default"].node,
    title: _propTypes["default"].string
  })
};
var _default = TreeView;
exports["default"] = _default;