"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function ContextMenu(_ref) {
  var _styles$menuWrapper, _styles$menuWrapper2;
  var isVisible = _ref.isVisible,
    setIsVisible = _ref.setIsVisible,
    menuItems = _ref.menuItems,
    nodeProps = _ref.nodeProps,
    classes = _ref.classes,
    styles = _ref.styles,
    clickMenuEvent = _ref.clickMenuEvent,
    emptyMenuText = _ref.emptyMenuText;
  var _useState = (0, _react.useState)({
      top: 0,
      left: 0
    }),
    _useState2 = _slicedToArray(_useState, 2),
    position = _useState2[0],
    setPosition = _useState2[1];
  var _useState3 = (0, _react.useState)(isVisible),
    _useState4 = _slicedToArray(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1];
  (0, _react.useEffect)(function () {
    if (isOpen) {
      setIsOpen(false);
    }
    var handleScroll = function handleScroll() {
      hideContextMenu();
    };
    window.addEventListener('scroll', handleScroll);
    return function () {
      window.removeEventListener('scroll', handleScroll);
    };
  }, [isVisible]);
  (0, _react.useEffect)(function () {
    if (isVisible && (nodeProps === null || nodeProps === void 0 ? void 0 : nodeProps.tree.props.data.length) > 0) {
      var event = clickMenuEvent.event;
      setPosition({
        top: event.clientY,
        left: event.clientX
      });
      setIsOpen(true);
    }
  }, [clickMenuEvent]);
  function MenuItem(_ref2) {
    var onClick = _ref2.onClick,
      children = _ref2.children;
    return /*#__PURE__*/_react["default"].createElement("div", {
      onContextMenu: function onContextMenu(e) {
        return e.preventDefault();
      },
      className: classes === null || classes === void 0 ? void 0 : classes.menuItem,
      style: styles === null || styles === void 0 ? void 0 : styles.menuItem,
      onClick: onClick
    }, children);
  }
  var hideContextMenu = function hideContextMenu() {
    setIsVisible(false);
  };
  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, isOpen && (nodeProps === null || nodeProps === void 0 ? void 0 : nodeProps.tree.props.data.length) > 0 && /*#__PURE__*/_react["default"].createElement("div", {
    style: {
      position: 'fixed',
      top: 0,
      left: 0,
      right: 0,
      bottom: 0,
      zIndex: 100
    },
    onClick: hideContextMenu,
    onContextMenu: function onContextMenu(e) {
      e.preventDefault();
      hideContextMenu();
    }
  }, /*#__PURE__*/_react["default"].createElement("div", {
    style: _objectSpread(_objectSpread({}, styles === null || styles === void 0 ? void 0 : styles.menuWrapper), {}, {
      position: 'fixed',
      top: (styles === null || styles === void 0 || (_styles$menuWrapper = styles.menuWrapper) === null || _styles$menuWrapper === void 0 ? void 0 : _styles$menuWrapper.top) || position.top + 'px',
      left: (styles === null || styles === void 0 || (_styles$menuWrapper2 = styles.menuWrapper) === null || _styles$menuWrapper2 === void 0 ? void 0 : _styles$menuWrapper2.left) || position.left + 'px'
    })
  }, /*#__PURE__*/_react["default"].createElement("div", {
    className: classes === null || classes === void 0 ? void 0 : classes.menuContainer,
    style: styles === null || styles === void 0 ? void 0 : styles.menuContainer
  }, menuItems.length > 0 ? menuItems.map(function (item) {
    return /*#__PURE__*/_react["default"].createElement(MenuItem, {
      key: item.id,
      onClick: item.action
    }, item.buttonContent);
  }) : /*#__PURE__*/_react["default"].createElement("div", {
    className: classes === null || classes === void 0 ? void 0 : classes.emptyMenu,
    style: styles === null || styles === void 0 ? void 0 : styles.emptyMenu
  }, emptyMenuText)))));
}
ContextMenu.defaultProps = {
  isVisible: false,
  setIsVisible: function setIsVisible() {},
  menuItems: [],
  classes: null,
  nodeProps: {},
  styles: null,
  clickMenuEvent: null,
  emptyMenuText: 'No menu items provided.'
};
ContextMenu.propTypes = {
  /** Properties of the current node */
  nodeProps: _propTypes["default"].object,
  /** If there is no menuItems, then we will see this text */
  emptyMenuText: _propTypes["default"].string,
  /** Indicates whether the context menu is visible or not */
  isVisible: _propTypes["default"].bool,
  /** Function to control the visibility of the context menu */
  setIsVisible: _propTypes["default"].func,
  /** Array of context menu items */
  menuItems: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string,
    buttonContent: _propTypes["default"].node,
    action: _propTypes["default"].func
  })),
  /** Class names for various elements */
  classes: _propTypes["default"].shape({
    /** Class for a single menu item */
    menuItem: _propTypes["default"].string,
    /** Class to wrap the entire context menu */
    menuWrapper: _propTypes["default"].string,
    /** Class for the menu item container */
    menuContainer: _propTypes["default"].string,
    /** Class for the message "No menu items" */
    emptyMenu: _propTypes["default"].string
  }),
  /** Component styles */
  styles: _propTypes["default"].shape({
    /** Style for a single menu item with background colors for normal (backgroundColor) and hover states (hoveredColor). */
    menuItem: _propTypes["default"].object,
    /** Style to wrap the entire context menu */
    menuWrapper: _propTypes["default"].object,
    /** Style for the menu item container */
    menuContainer: _propTypes["default"].object,
    /** Style for the message "No menu items" */
    emptyMenu: _propTypes["default"].object
  }),
  /** An object that contains information about the event that triggers the context menu */
  clickMenuEvent: _propTypes["default"].object
};
var _default = ContextMenu;
exports["default"] = _default;