"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _editorjsBlocksReactRenderer = _interopRequireDefault(require("editorjs-blocks-react-renderer"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function ListOfNotes(_ref) {
  var notes = _ref.notes,
    removeNote = _ref.removeNote,
    setNoteId = _ref.setNoteId,
    classes = _ref.classes,
    style = _ref.style,
    delBtnChildren = _ref.delBtnChildren,
    isShowDate = _ref.isShowDate,
    isShowText = _ref.isShowText,
    isShowDelBtn = _ref.isShowDelBtn,
    dateOptions = _ref.dateOptions,
    editNoteTitle = _ref.editNoteTitle;
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    editingTitle = _useState2[0],
    setEditingTitle = _useState2[1];
  var handleClick = function handleClick(id) {
    setNoteId(id);
  };
  var handleRemoveNote = function handleRemoveNote(e, id) {
    e.stopPropagation();
    removeNote(id);
  };
  var handleTitleClick = function handleTitleClick(e, id) {
    e.stopPropagation();
    if (!editNoteTitle) {
      setNoteId(id);
    }
  };
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: classes === null || classes === void 0 ? void 0 : classes.wrapper,
    style: style === null || style === void 0 ? void 0 : style.wrapper
  }, notes === null || notes === void 0 ? void 0 : notes.map(function (note) {
    return /*#__PURE__*/_react["default"].createElement("div", {
      key: note.id,
      className: classes === null || classes === void 0 ? void 0 : classes.item,
      style: style === null || style === void 0 ? void 0 : style.item,
      onClick: function onClick() {
        return handleClick(note.id);
      }
    }, /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.titleBlock,
      style: style === null || style === void 0 ? void 0 : style.titleBlock,
      onClick: function onClick(e) {
        return handleTitleClick(e, note.id);
      }
    }, editNoteTitle && editingTitle === note.id ? /*#__PURE__*/_react["default"].createElement("input", {
      autoFocus: true,
      type: "text",
      defaultValue: note.title,
      style: style === null || style === void 0 ? void 0 : style.renameInput,
      className: classes === null || classes === void 0 ? void 0 : classes.renameInput,
      onBlur: function onBlur() {
        return setEditingTitle(null);
      },
      onFocus: function onFocus(e) {
        return e.currentTarget.select();
      },
      onKeyDown: function onKeyDown(e) {
        if (e.key === 'Escape') setEditingTitle(null);
        if (e.key === 'Enter') {
          editNoteTitle(note.id, e.target.value);
          setEditingTitle(null);
        }
      }
    }) : /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.title,
      style: style === null || style === void 0 ? void 0 : style.title,
      onDoubleClick: function onDoubleClick() {
        return setEditingTitle(note.id);
      }
    }, note.title)), isShowText && /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.text,
      style: style === null || style === void 0 ? void 0 : style.text
    }, /*#__PURE__*/_react["default"].createElement(_editorjsBlocksReactRenderer["default"], {
      data: note.data
    })), isShowDelBtn && /*#__PURE__*/_react["default"].createElement("button", {
      className: classes === null || classes === void 0 ? void 0 : classes.delBtn,
      style: style === null || style === void 0 ? void 0 : style.delBtn,
      onClick: function onClick(e) {
        return handleRemoveNote(e, note.id);
      }
    }, delBtnChildren), isShowDate && note.created_at && /*#__PURE__*/_react["default"].createElement("div", {
      className: classes === null || classes === void 0 ? void 0 : classes.date,
      style: style === null || style === void 0 ? void 0 : style.date
    }, new Date(note.created_at).toLocaleString('ru', dateOptions)));
  }));
}
ListOfNotes.defaultProps = {
  editNoteTitle: null,
  notes: [],
  style: {},
  classes: {},
  dateOptions: {},
  isShowDate: false,
  isShowText: false,
  isShowDelBtn: false,
  title: 'untitled',
  delBtnChildren: 'Delete',
  setNoteId: function setNoteId() {}
};
ListOfNotes.propTypes = {
  /** component styles */
  style: _propTypes["default"].shape({
    /** style for wrapper */
    wrapper: _propTypes["default"].object,
    /** style to preview each note */
    item: _propTypes["default"].object,
    /** style for titleBlock */
    titleBlock: _propTypes["default"].object,
    /** style for title */
    title: _propTypes["default"].object,
    /** style for the input field when renaming */
    renameInput: _propTypes["default"].object,
    /** style for text */
    text: _propTypes["default"].object,
    /** style for delBtn */
    delBtn: _propTypes["default"].object,
    /** style for date */
    date: _propTypes["default"].object
  }),
  /** function to edit the title of a note */
  editNoteTitle: _propTypes["default"].func,
  classes: _propTypes["default"].shape({
    /** class for wrapper */
    wrapper: _propTypes["default"].string,
    /** class for titleBlock */
    titleBlock: _propTypes["default"].string,
    /** class for title */
    title: _propTypes["default"].string,
    /** class to preview each note */
    item: _propTypes["default"].string,
    /** class for delBtn */
    delBtn: _propTypes["default"].string,
    /** class for date */
    date: _propTypes["default"].string,
    /** class for text */
    text: _propTypes["default"].string
  }),
  /** you can change the date representation (https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleString) */
  dateOptions: _propTypes["default"].object,
  /** note title in preview */
  title: _propTypes["default"].string,
  /** an array of existing notes. Required to display a list of notes */
  notes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string,
    title: _propTypes["default"].string,
    data: _propTypes["default"].object,
    created_at: _propTypes["default"].instanceOf(Date)
  })),
  /** function to remove a note */
  removeNote: _propTypes["default"].func,
  /** pass the id of the selected note to the setter */
  setNoteId: _propTypes["default"].func,
  /** if true, display delete button for each note */
  isShowDelBtn: _propTypes["default"].bool,
  /** content of the delete button */
  delBtnChildren: _propTypes["default"].node,
  /** if true, display note creation date during note preview */
  isShowDate: _propTypes["default"].bool,
  /** if true, display note text during note preview */
  isShowText: _propTypes["default"].bool
};
var _default = ListOfNotes;
exports["default"] = _default;