// homeModel.js
const mongoose = require('mongoose');

// Schema for videos
const videoSchema = new mongoose.Schema({
    title: {
        type: String,
        required: true
    },
    description: {
        type: String
    },
    source: {
        type: String
    },
    video_link: {
        type: String
    },
    videoCount: {
        type: Number
    },
    inrolled_users:{
        type: Number
    },
    categoryId:{
        type: String,
        ref: 'category'
    },
    status:{
        type: String
    }
});

// Schema for chapters
const chapterSchema = new mongoose.Schema({
    title: {
        type: String,
        required: true
    },
    description: {
        type: String
    },
    video_link: {
        type: String
    },
    source: {
        type: String
    },
    categoryId: {
        type: String,
        ref: 'category'
    },
    courseId:{
        type: String,
        ref: 'courses'
    }
    // Add more fields as needed
});

const Video = mongoose.model('Video', videoSchema);
const Chapter = mongoose.model('Chapter', chapterSchema);

module.exports = { Video, Chapter };
