const express = require("express");
const {fetchEnrollment, insertEnrollment, updateEnrollment, deleteEnrollment } = require("../Controller/enrollmentController");
const { verifyAdmin, verifyToken } = require("../../Auth/verify");
const router = express.Router();

//for admin pannel api...

//fetch Enrollment
router.get('/fetch',verifyAdmin, fetchEnrollment);

//insert Enrollment
router.post('/insert',verifyAdmin, insertEnrollment);

//update Enrollment
router.post('/update',verifyAdmin, updateEnrollment);

//delete Enrollment
router.post('/delete',verifyAdmin, deleteEnrollment);

module.exports = router;