const express = require("express");
const { listCategories, fetchCategory,fetchSubCategory, createCategory, categoryUpdate, categoryRemove, addSubcategory, updateSubcategory, deleteSubcategory } = require("../Controller/categoryConroller");
const router = express.Router();
const {verifyAdmin, verifyToken} = require('../../Auth/verify')

 //---------------------------------routes for user api-------------------------------------//

router.get('/', verifyToken, listCategories);

//---------------------------------routes for admin api-------------------------------------//

//fetch categories..
router.get('/fetch',verifyAdmin, fetchCategory);

//fetch subcategories..
router.get('/fetch/subcategory',verifyAdmin, fetchSubCategory);

//for insert category
router.post('/create',verifyAdmin, createCategory);

//for update category
router.post('/update',verifyAdmin, categoryUpdate);

//for delete category
router.post('/delete',verifyAdmin, categoryRemove);

//for add subcategories 
router.post('/add/subcategory',verifyAdmin, addSubcategory);

//update subcategory
router.post('/update/subcategory',verifyAdmin, updateSubcategory);

//update subcategory
router.post('/delete/subcategory',verifyAdmin, deleteSubcategory);

module.exports = router;