// homeController.js
const { Video, Chapter } = require('../model/homeModel');
const multer = require('multer');
const fs = require('fs');
const path = require('path');



// Controller function to fetch videos
const getVideos = async (req, res) => {
    try { 
        // Fetch all videos from the database
        const courses = await Video.find();
        res.status(200).json({ courses });
    } catch (error) {
        console.error("Error fetching videos:", error);
        res.status(500).send("Internal Server Error");
    }
};

// Controller function to fetch chapters
const getChapters = async (req, res) => {
        const courseId = req.query.courseId;
    try {
        // Fetch all chapters from the database
        const chapters = await Chapter.find({ courseId: courseId });
        console.log(chapters);
        res.status(200).json({ chapters });
    } catch (error) {
        console.error("Error fetching chapters:", error);
        res.status(500).send("Internal Server Error");
    }
};
//Apis for admin pannel--------------------------------
//fetching all courses

const courses = async (req, res) =>{
    try {
        const Courses = await Video.find();
        
        res.status(200).json({
            success: true,
            Courses: Courses
        });
    } catch (error) {
        console.error("Error fetching Courses:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error"
        });
    }
};

//for inserting cours
const upload = multer({
    storage: multer.diskStorage({
        destination: function (req, file, cb) {
            const uploadPath = path.join('public', 'videos');
            fs.mkdirSync(uploadPath, { recursive: true });
            cb(null, uploadPath);
        },
        filename: function (req, file, cb) {
            const fileName = file.originalname.replace(/\s+/g, '_');
            cb(null, fileName);
        },
    }),
});

const addCourse = async (req, res) => {

    upload.single('video_link')(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading video:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading video:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const video_link = req.file ? req.file.filename : null;

     
        const courseDetails = {
            title: req.body.CoursName,
            description: req.body.description,
            videoCount: req.body.videos,
            source: req.body.source,
            video_link: video_link, 
            inrolled_users: req.body.inrolled_users,
            status: req.body.status,
            categoryId: req.body.categoryId
        };

        try {

            await Video.create(courseDetails);
            console.log("Course Added successfully");
            res.status(200).send("Course Added Successfully");
        } catch (error) {
            console.error("Error processing Course add:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};

//for update courses
const updateCourse = async (req, res) => {
  

    upload.single('video_link')(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading video:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading video:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const courseDetails = {
            title: req.body.CoursName,
            description: req.body.description,
            videoCount: req.body.videos,
            source: req.body.source,
            video_link: req.file ? req.file.filename : req.body.video_link,
            inrolled_users: req.body.inrolled_users,
            status: req.body.status,
            categoryId: req.body.categoryId
        };

        const courseId = req.body.courseId;

        try {
            const updatedCourse = await Video.findByIdAndUpdate(courseId, courseDetails);
            if (updatedCourse) {
                console.log("Course Updated Successfully");
                res.status(200).send("Course Updated Successfully");
            } else {
                console.error("Course not found with ID:", courseId);
                res.status(404).send("Course not found");
            }
        } catch (error) {
            console.error("Error processing Course Update:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};

//delete cours
const deleteCourse = async (req,res)=>{

    const courseId = req.body.courseId;

    try{
        const deleteCourse = await Video.deleteOne({ _id: courseId });
        console.log(deleteCourse);
        if(deleteCourse){
            console.log("Course Delete Successfully");
            res.status(200).send("Course Delete Successfully");
        }else{
            console.error("Course not found with ID:", userId);
            res.status(404).send("Course not found");
        }
    }catch(error){
        console.error("Error processing Course Delete:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

//for fetch chapters
const fetchChapter = async (req, res)=>{
    try {
        const chapter = await Chapter.find();
        
        res.status(200).json({
            success: true,
            chapter: chapter
        });
    } catch (error) {
        console.error("Error fetching chapter:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error"
        });
    }
}


const uploadChapter = multer({
    storage: multer.diskStorage({
        destination: function (req, file, cb) {
            // Define the destination directory for chapter video uploads
            const uploadPath = path.join('public', 'chapters');
            fs.mkdirSync(uploadPath, { recursive: true });
            cb(null, uploadPath);
        },
        filename: function (req, file, cb) {
            const fileName = file.originalname.replace(/\s+/g, '_');
            cb(null, fileName);
        },
    }),
});

//for inserting chapters
const addChapter = async (req, res) => {
    // Use multer middleware for chapter video uploads
    uploadChapter.single('video_link')(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading chapter video:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading chapter video:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const video_link = req.file ? req.file.filename : null;

        const chapterDetails = {
            title: req.body.chapterName,
            description: req.body.description,
            source: req.body.source,
            video_link: video_link,
            courseId: req.body.courseId,
            categoryId: req.body.categoryId
        };

        try {
            await Chapter.create(chapterDetails);
            console.log("Chapter Added successfully");
            res.status(200).send("Chapter Added Successfully");
        } catch (error) {
            console.error("Error processing Chapter add:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    });
};

//for update chapters
const updateChapter = async (req, res) =>{

    uploadChapter.single('video_link')(req, res, async function (err) {
        if (err instanceof multer.MulterError) {
            console.error("Error uploading chapter video:", err);
            return res.status(500).json({ error: "File upload error" });
        } else if (err) {
            console.error("Error uploading chapter video:", err);
            return res.status(500).json({ error: "Internal Server Error" });
        }

        const video_link = req.file ? req.file.filename : null;

    const chapterDetails = {
        title: req.body.chapterName,
        description: req.body.description,
        source: req.body.source,
        video_link: video_link,
        courseId: req.body.courseId,
        categoryId: req.body.categoryId
    };

    const chapterId = req.body.chapterId;

    try {
        const updatedChapter = await Chapter.findByIdAndUpdate(chapterId, chapterDetails);
        if(updatedChapter){
            console.log("Chapter Updated Successfully");
            res.status(200).send("Chapter Updated Successfully");
        }else{
            console.error("Chapter not found with ID:", chapterId);
            res.status(404).send("Chapter not found");
        }
    } catch (error) {
        console.error("Error processing Chapter add:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
    });
};


const deleteChapter = async (req, res)=>{

    const chapterId = req.body.chapterId;

    try{
        const deletechapter = await Chapter.deleteOne({ _id: chapterId });
        console.log(deletechapter);
        if(deletechapter){
            console.log("chapter Delete Successfully");
            res.status(200).send("chapter Delete Successfully");
        }else{
            console.error("chapter not found with ID:", userId);
            res.status(404).send("chapter not found");
        }
    }catch(error){
        console.error("Error processing chapter Delete:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

module.exports = 
    {
     getVideos,
     getChapters,
     courses,
     addCourse,
     updateCourse,
     deleteCourse,
     fetchChapter,
     addChapter,
     updateChapter,
     deleteChapter,
     };

