const enrollmentModel = require("../model/enrollmentModel");
const fs = require('fs');
const path = require('path');


exports.fetchEnrollment = async (req, res)=>{
    try{
        const enrollments = await enrollmentModel.find();
        res.status(200).json({
            success: true,
            enrollments: enrollments,
        });
    }catch(error){
        console.error("Error fetching Enrollments:", error);
        res.status(500).json({
            success: false,
            message: "Internal Server Error",
        });
    }
}

exports.insertEnrollment = async (req, res)=>{
    const enrollment ={
        role : req.body.role,
        courses_to_enroll : req.body.courses_to_enroll
    }; 

    try{
        await enrollmentModel.create(enrollment);
        console.log("enrollment Added successfully");
        res.status(200).send("enrollment Added Successfully");
    }catch(error){
        console.error("Error processing enrollment add:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

exports.updateEnrollment = async (req, res)=>{
    const enrollment ={
        role : req.body.role,
        courses_to_enroll : req.body.courses_to_enroll
    }; 
    const enrollmentId = req.body.enrollmentId;
    try{
        await enrollmentModel.findByIdAndUpdate(enrollmentId, enrollment);
        console.log("enrollment updated successfully");
        res.status(200).send("enrollment updated Successfully");
    }catch(error){
        console.error("Error processing enrollment update:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
};

exports.deleteEnrollment = async (req, res)=>{
    const enrollmentId = req.body.enrollmentId;
    try{
        const deleteenrollment = await enrollmentModel.deleteOne({ _id: enrollmentId });
       // console.log(deletesubCategory);
        if(deleteenrollment){
            console.log("Enrollment Delete Successfully");
            res.status(200).send("Enrollment Delete Successfully");
        }else{
            console.error("Enrollment not found with ID:", userId);
            res.status(404).send("Enrollment not found");
        }
    }catch(error){
        console.error("Error processing Enrollment Delete:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }

};