/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    p = require("path"),
    FileSystemScanner = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemScanner"),
    SynchronousFileSystemStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemStrategy/Synchronous"),
    ScanningStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningStrategy");

describe("JsLoader/FileSystem/ScanningStrategy", function () {
    describe("using FileSystemScanner#scanPath", function () {
        it("is able to not scan all given directories", function () {
            var fileSystemScanner,
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                scanningProcess,
                scanningStrategy = new ScanningStrategy();

            fileSystemScanner = new FileSystemScanner(scanningStrategy, fileSystemStrategy);
            scanningStrategy.shouldScanDirectory = function (path, fileSystemStrategy, callback) {
                callback(global.MODULE_ROOT_TESTS === path);
            };

            scanningProcess = fileSystemScanner.scanPath(global.MODULE_ROOT_TESTS);
            assert.equal(scanningProcess.foundFiles.length, 1);
            assert.equal(scanningProcess.foundDirectories.length, 1);
        });
        it("is able to not scan all given directories and files", function () {
            var fileSystemScanner,
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                scanningProcess,
                scanningStrategy = new ScanningStrategy();

            fileSystemScanner = new FileSystemScanner(scanningStrategy, fileSystemStrategy);
            scanningStrategy.shouldScanDirectory = function (path, fileSystemStrategy, callback) {
                var allowedNames = ["directory_1", "fixtures", "search_site_1", "tests"];

                callback(-1 !== allowedNames.indexOf(p.basename(path)));
            };
            scanningStrategy.shouldScanFile = function (path, fileSystemStrategy, callback) {
                callback("search_target.txt" === p.basename(path));
            };

            scanningProcess = fileSystemScanner.scanPath(global.MODULE_ROOT_TESTS);
            assert.equal(scanningProcess.foundDirectories.length, 4);
            assert.equal(scanningProcess.foundFiles.length, 1);
        });
        it("is able to not scan all given files", function () {
            var fileSystemScanner,
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                scanningProcess,
                scanningStrategy = new ScanningStrategy();

            fileSystemScanner = new FileSystemScanner(scanningStrategy, fileSystemStrategy);
            scanningStrategy.shouldScanFile = function (path, fileSystemStrategy, callback) {
                callback("search_target.txt" === p.basename(path));
            };

            scanningProcess = fileSystemScanner.scanPath(global.MODULE_ROOT_TESTS);
            assert.equal(scanningProcess.foundFiles.length, 2);
        });
        it("is able to not scan all given paths", function () {
            var fileSystemScanner,
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                scanningProcess,
                scanningStrategy = new ScanningStrategy();

            fileSystemScanner = new FileSystemScanner(scanningStrategy, fileSystemStrategy);
            scanningStrategy.shouldScanPath = function (path, fileSystemStrategy, callback) {
                var allowedNames = ["fixtures", "search_site_1", "tests"];

                callback(-1 !== allowedNames.indexOf(p.basename(path)));
            };

            scanningProcess = fileSystemScanner.scanPath(global.MODULE_ROOT_TESTS);
            assert.equal(scanningProcess.foundFiles.length, 0);
            assert.equal(scanningProcess.foundDirectories.length, 3);
        });
    });
});
