/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    File = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningStrategy/Pattern/File"),
    SynchronousFileSystemStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemStrategy/Synchronous");

describe("JsLoader/FileSystem/ScanningStrategy/Pattern/File", function () {

    describe("in general", function () {

        it("is cannot be constructed without a pattern", function () {
            var file;

            assert.throws(function () {
                file = new File();
            }, Error);
        });

        it("is looking for file", function () {
            var file = new File("pattern");

            assert.ok(file.isLookingForFile);
        });

        it("is not looking for directory", function () {
            var file = new File("pattern");

            assert.ok(!file.isLookingForDirectory);
        });

    });

    describe("#checkFile", function () {

        it("matches file", function () {
            var file = new File(/worl?d/),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = "hello/word",
                isMatching;

            file.checkFile(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(isMatching);
        });

        it("does not match file", function () {
            var file = new File("word"),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = "word/foo",
                isMatching;

            file.checkFile(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(!isMatching);
        });

    });

    describe("#checkFile", function () {

        it("always reports that directory does not match the pattern", function () {
            var file = new File("ScanningStrategy"),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = __dirname,
                isMatching;

            file.checkFile(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(!isMatching);
        });

    });

});
