/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    Directory = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningStrategy/Pattern/Directory"),
    SynchronousFileSystemStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemStrategy/Synchronous");

describe("JsLoader/FileSystem/ScanningStrategy/Pattern/Directory", function () {

    describe("in general", function () {

        it("is cannot be constructed without a pattern", function () {
            var directory;

            assert.throws(function () {
                directory = new Directory();
            }, Error);
        });

        it("is looking for directory", function () {
            var directory = new Directory("pattern");

            assert.ok(directory.isLookingForDirectory);
        });

        it("is not looking for file", function () {
            var directory = new Directory("pattern");

            assert.ok(!directory.isLookingForFile);
        });

    });

    describe("#checkDirectory", function () {

        it("matches directory", function () {
            var directory = new Directory(/worl?d/),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = "hello/word",
                isMatching;

            directory.checkDirectory(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(isMatching);
        });

        it("does not match directory", function () {
            var directory = new Directory("word"),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = "word/foo",
                isMatching;

            directory.checkDirectory(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(!isMatching);
        });

    });

    describe("#checkFile", function () {

        it("always reports that file does not match the pattern", function () {
            var directory = new Directory("ScanningStrategy"),
                fileSystemStrategy = new SynchronousFileSystemStrategy(),
                inputPath = __dirname,
                isMatching;

            directory.checkFile(inputPath, fileSystemStrategy, function (innerIsMatching) {
                isMatching = innerIsMatching;
            });

            assert.ok(!isMatching);
        });

    });

});
