/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    ScanningResult = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningResult");

describe("JsLoader/FileSystem/ScanningResult", function () {
    describe("#notifyDone", function () {
        it("dispatches done event with current search snapshot", function (done) {
            var scanningResult = new ScanningResult();

            scanningResult.start();
            scanningResult.addListenerDone(function (evt) {
                assert.deepEqual(evt.foundFiles, ["foo"]);
                assert.deepEqual(evt.foundPaths, evt.foundFiles);

                done();
            });

            scanningResult.foundFiles.push("foo");
            scanningResult.done();
        });
    });
    describe("#notifyFail", function () {
        it("dispatches fail event with current search snapshot", function (done) {
            var scanningResult = new ScanningResult();

            scanningResult.start();
            scanningResult.addListenerFail(function (evt) {
                assert.deepEqual(evt.foundFiles, ["foo"]);
                assert.deepEqual(evt.foundPaths, evt.foundFiles);

                done();
            });

            scanningResult.foundFiles.push("foo");
            scanningResult.fail();
        });
    });
    describe("#notifyStop", function () {
        it("dispatches stop event with current search snapshot", function (done) {
            var scanningResult = new ScanningResult();

            scanningResult.start();
            scanningResult.addListenerStop(function (evt) {
                assert.deepEqual(evt.foundDirectories, ["foo"]);
                assert.deepEqual(evt.foundPaths, evt.foundDirectories);

                done();
            });

            scanningResult.foundDirectories.push("foo");
            scanningResult.stop();
        });
    });
});
