/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    p = require("path"),
    ScanningBranch = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningBranch");

describe("JsLoader/FileSystem/ScanningBranch", function () {
    describe("#coversPath", function () {
        it("checks if path belongs to given branch or not", function () {
            var scanningBranch = new ScanningBranch({});

            scanningBranch.visitedFiles.push(["a"].join(p.sep));
            scanningBranch.visitedFiles.push(["a", "b"].join(p.sep));
            scanningBranch.visitedFiles.push(["a", "b", "c"].join(p.sep));

            assert.ok(scanningBranch.coversPath(["a"].join(p.sep)));
            assert.ok(!scanningBranch.coversPath(["ab"].join(p.sep)));
            assert.ok(scanningBranch.coversPath(["a", "b"].join(p.sep)));
            assert.ok(scanningBranch.coversPath(["a", "b", "c"].join(p.sep)));
            assert.ok(!scanningBranch.coversPath(["a", "b", "d"].join(p.sep)));
            assert.ok(scanningBranch.coversPath(["a", "b", "c", "e"].join(p.sep)));
            assert.ok(scanningBranch.coversPath(["a", "b", "c", "f"].join(p.sep)));
        });
    });
});
