/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    // AsynchronousFileSystemStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemStrategy/Asynchronous"),
    DirectoryScanningStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningStrategy/Pattern/Directory"),
    FileScanningStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/ScanningStrategy/Pattern/File"),
    RememberingFileSystemScanner = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemScanner/Remembering"),
    SynchronousFileSystemStrategy = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/FileSystem/FileSystemStrategy/Synchronous");

describe("JsLoader/FileSystem/FileSystemScanner/Remembering", function () {

    describe("using different strategies", function () {

        it("requires ScanningStrategy and FileSystemStrategy to be constructed", function () {
            var fileSystemScanner;

            assert.throws(function () {
                fileSystemScanner = new RememberingFileSystemScanner();
            }, Error);
        });

    });

    describe("#scanDirectory", function () {

        it("does not scan given directory twice", function () {
            var fileSystemStrategy = new SynchronousFileSystemStrategy(),
                fileSystemScanner,
                scanningProcess,
                scanningStrategy = new DirectoryScanningStrategy(/.*/);

            fileSystemScanner = new RememberingFileSystemScanner(scanningStrategy, fileSystemStrategy);

            assert.ok(!fileSystemScanner.isDirectoryScanned(__dirname));
            assert.ok(!fileSystemScanner.isPathScanned(__dirname));
            scanningProcess = fileSystemScanner.scanDirectory(__dirname);

            assert.ok(fileSystemScanner.isDirectoryScanned(__dirname));
            assert.ok(fileSystemScanner.isPathScanned(__dirname));
            assert.deepEqual(scanningProcess.foundDirectories, [__dirname]);

            scanningProcess = fileSystemScanner.scanDirectory(__dirname);
            assert.deepEqual(scanningProcess.foundDirectories, [__dirname]);
        });

    });

    describe("#scanFile", function () {

        it("does not scan given file twice", function () {
            var fileSystemStrategy = new SynchronousFileSystemStrategy(),
                fileSystemScanner,
                scanningProcess,
                scanningStrategy = new FileScanningStrategy(/.*/);

            fileSystemScanner = new RememberingFileSystemScanner(scanningStrategy, fileSystemStrategy);

            assert.ok(!fileSystemScanner.isFileScanned(__filename));
            assert.ok(!fileSystemScanner.isPathScanned(__filename));
            scanningProcess = fileSystemScanner.scanFile(__filename);

            assert.ok(fileSystemScanner.isFileScanned(__filename));
            assert.ok(fileSystemScanner.isPathScanned(__filename));
            assert.deepEqual(scanningProcess.foundFiles, [__filename]);

            scanningProcess = fileSystemScanner.scanFile(__filename);
            assert.deepEqual(scanningProcess.foundFiles, [__filename]);
        });

    });

    describe("#scanPath", function () {

        it("does not scan given path twice", function () {
            var fileSystemStrategy = new SynchronousFileSystemStrategy(),
                fileSystemScanner,
                scanningProcess,
                scanningStrategy = new FileScanningStrategy(/.*/);

            fileSystemScanner = new RememberingFileSystemScanner(scanningStrategy, fileSystemStrategy);

            assert.ok(!fileSystemScanner.isDirectoryScanned(__filename));
            assert.ok(!fileSystemScanner.isFileScanned(__filename));
            assert.ok(!fileSystemScanner.isPathScanned(__filename));
            scanningProcess = fileSystemScanner.scanPath(__filename);

            assert.ok(!fileSystemScanner.isDirectoryScanned(__filename));
            assert.ok(fileSystemScanner.isFileScanned(__filename));
            assert.ok(fileSystemScanner.isPathScanned(__filename));
            assert.deepEqual(scanningProcess.foundFiles, [__filename]);
            assert.deepEqual(scanningProcess.foundDirectories, []);

            scanningProcess = fileSystemScanner.scanPath(__filename);
            assert.deepEqual(scanningProcess.foundFiles, [__filename]);
            assert.deepEqual(scanningProcess.foundDirectories, []);
        });

    });

    describe("#scanPaths", function () {

        it("does not accept non-array paths list", function () {
            var fileSystemStrategy = new SynchronousFileSystemStrategy(),
                fileSystemScanner,
                scanningStrategy = new FileScanningStrategy(/.*/);

            fileSystemScanner = new RememberingFileSystemScanner(scanningStrategy, fileSystemStrategy);

            assert.throws(function () {
                fileSystemScanner.scanPaths("non-array list");
            });
        });

        it("does not scan given paths twice", function () {
            var fileSystemStrategy = new SynchronousFileSystemStrategy(),
                fileSystemScanner,
                scanningProcess,
                scanningStrategy = new FileScanningStrategy(/.*/);

            fileSystemScanner = new RememberingFileSystemScanner(scanningStrategy, fileSystemStrategy);

            assert.ok(!fileSystemScanner.isDirectoryScanned(__filename));
            assert.ok(!fileSystemScanner.isFileScanned(__filename));
            assert.ok(!fileSystemScanner.isPathScanned(__filename));
            scanningProcess = fileSystemScanner.scanPaths([__filename, __dirname]);

            assert.ok(!fileSystemScanner.isDirectoryScanned(__filename));
            assert.ok(fileSystemScanner.isFileScanned(__filename));
            assert.ok(fileSystemScanner.isPathScanned(__filename));
            assert.deepEqual(scanningProcess.foundFiles, [__filename]);
            assert.deepEqual(scanningProcess.foundDirectories, []);

            scanningProcess = fileSystemScanner.scanPaths([__filename, __dirname]);
            assert.deepEqual(scanningProcess.foundFiles, []);
            assert.deepEqual(scanningProcess.foundDirectories, []);
        });

    });

});
