/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    filesystem = require(global.MODULE_ROOT + "/libraries/modules/filesystem");

describe("JsLoader/FileSystem/modules/filesystem", function () {

    describe("#scanPath", function () {
        it("takes at lease one argument - which is a path to scan", function () {
            assert.throws(function () {
                filesystem.scanPath();
            });
        });
        it("can omit options", function (done) {
            filesystem.scanPath(global.MODULE_ROOT_TESTS, function (evt) {
                assert.equal(evt.foundDirectories.length, 19);
                assert.equal(evt.foundFiles.length, 20);

                done();
            });
        });
        it("can omit callback", function (done) {
            var cb = filesystem.scanPath(global.MODULE_ROOT_TESTS);

            cb.addListenerDone(function (evt) {
                assert.equal(evt.foundDirectories.length, 19);
                assert.equal(evt.foundFiles.length, 20);

                done();
            });
        });
        it("can use syntax sugar", function (done) {
            filesystem.scanPath(global.MODULE_ROOT_TESTS, (/search_tgt/), function (evt) {
                assert.equal(evt.foundDirectories.length, 1);
                assert.equal(evt.foundFiles.length, 2);

                done();
            });
        });
        it("must look for something", function () {
            assert.throws(function () {
                filesystem.scanPath(global.MODULE_ROOT_TESTS, {
                    isLookingForDirectory: false,
                    isLookingForFile: false
                }, function (evt) {});
            });
        });
        it("reports that directory was found", function (done) {
            var pattern = (/directory_([0-9]+)/);

            filesystem.scanPath(global.MODULE_ROOT_TESTS, {
                isLookingForDirectory: true,
                isLookingForFile: false,
                pattern: pattern
            }, function (evt) {
                assert.equal(evt.foundDirectories.length, 4);
                assert.equal(evt.foundFiles.length, 0);

                done();
            });
        });
        it("reports that file was found", function (done) {
            var pattern = (/search_tgt(_[0-9]+)?.txt$/);

            filesystem.scanPath(global.MODULE_ROOT_TESTS, {
                isLookingForDirectory: false,
                isLookingForFile: true,
                limit: 2,
                pattern: pattern
            }, function (evt) {
                assert.equal(evt.foundDirectories.length, 0);
                assert.equal(evt.foundFiles.length, 2);

                done();
            });
        });
    });

    describe("#scanPathSync", function () {
        it("returns scan summary in place", function () {
            var evt;

            evt = filesystem.scanPathSync(global.MODULE_ROOT_TESTS);

            assert.equal(evt.foundDirectories.length, 19);
            assert.equal(evt.foundFiles.length, 20);
        });
    });

});
