/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var File, // constructor, function
    Pattern = require(__dirname + "/../Pattern"), // constructor, function
    ScanningStrategy = require(__dirname + "/../../ScanningStrategy"); // constructor, function

/**
 * @abstract
 * @auguments JsLoader/FileSystem/ScanningStrategy/Pattern
 * @borrows JsLoader/FileSystem/ScanningStrategy#checkDirectory as checkDirectory
 * @constructor
 * @param {RegExp|String} pattern
 */
File = function (pattern) {
    Pattern.call(this, pattern);
};
File.prototype = Object.create(Pattern.prototype);
File.prototype.checkDirectory = ScanningStrategy.prototype.checkDirectory;
File.prototype.isLookingForDirectory = false;

module.exports = File;
