/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var Directory, // constructor, function
    Pattern = require(__dirname + "/../Pattern"), // constructor, function
    ScanningStrategy = require(__dirname + "/../../ScanningStrategy"); // constructor, function

/**
 * @abstract
 * @auguments JsLoader/FileSystem/ScanningStrategy/Pattern
 * @borrows JsLoader/FileSystem/ScanningStrategy#checkFile as checkFile
 * @constructor
 * @param {RegExp|String} pattern
 */
Directory = function (pattern) {
    Pattern.call(this, pattern);
};
Directory.prototype = Object.create(Pattern.prototype);
Directory.prototype.checkFile = ScanningStrategy.prototype.checkFile;
Directory.prototype.isLookingForFile = false;

module.exports = Directory;
