/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var ScanningStrategy; // constructor, function

/**
 * @constructor
 */
ScanningStrategy = function () {};

/**
 * @return {bool}
 */
ScanningStrategy.prototype.isLookingForDirectory = true;

/**
 * @return {bool}
 */
ScanningStrategy.prototype.isLookingForFile = true;

/**
 * @callback JsLoader/FileSystem/ScanningStrategy~checkDirectoryCallback
 * @param {bool} isFound
 * @return {void}
 */

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy} fileSystemStrategy
 * @param {JsLoader/FileSystem/ScanningStrategy~checkDirectoryCallback} callback
 * @return {void}
 */
ScanningStrategy.prototype.checkDirectory = function (path, fileSystemStrategy, callback) {
    callback(this.isLookingForDirectory);
};

/**
 * @callback JsLoader/FileSystem/ScanningStrategy~checkFileCallback
 * @param {bool} isFound
 * @return {void}
 */

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy} fileSystemStrategy
 * @param {JsLoader/FileSystem/ScanningStrategy~checkFileCallback} callback
 * @return {void}
 */
ScanningStrategy.prototype.checkFile = function (path, fileSystemStrategy, callback) {
    callback(this.isLookingForFile);
};

/**
 * @callback JsLoader/FileSystem/ScanningStrategy~shouldScanDirectoryCallback
 * @param {bool} shouldScan
 * @return {void}
 */

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy} fileSystemStrategy
 * @param {JsLoader/FileSystem/ScanningStrategy~shouldScanDirectoryCallback} callback
 * @return {void}
 */
ScanningStrategy.prototype.shouldScanDirectory = function (path, fileSystemStrategy, callback) {
    callback(true);
};

/**
 * @callback JsLoader/FileSystem/ScanningStrategy~shouldScanFileCallback
 * @param {bool} shouldScan
 * @return {void}
 */

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy} fileSystemStrategy
 * @param {JsLoader/FileSystem/ScanningStrategy~shouldScanFileCallback} callback
 * @return {void}
 */
ScanningStrategy.prototype.shouldScanFile = function (path, fileSystemStrategy, callback) {
    callback(this.isLookingForFile);
};

/**
 * @callback JsLoader/FileSystem/ScanningStrategy~shouldScanPathCallback
 * @param {bool} shouldScan
 * @return {void}
 */

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy} fileSystemStrategy
 * @param {JsLoader/FileSystem/ScanningStrategy~shouldScanPathCallback} callback
 * @return {void}
 */
ScanningStrategy.prototype.shouldScanPath = function (path, fileSystemStrategy, callback) {
    callback(true);
};

module.exports = ScanningStrategy;
