/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var ScanningResult, // constructor, function
    Task = require("flow-inspector").Task;

/**
 * @auguments flow-inspector/Task
 * @constructor
 */
ScanningResult = function () {
    Task.call(this);

    this.expectedDirectories = [];
    this.expectedFiles = [];
    this.foundDirectories = [];
    this.foundFiles = [];
    this.foundDirectories = [];
    this.foundFiles = [];
    this.visitedDirectories = [];
    this.visitedFiles = [];

    Object.defineProperties(this, {
        expectedPaths: {
            enumerable: true,

            /**
             * @return {array}
             */
            get: function () {
                return this.expectedDirectories.concat(this.expectedFiles);
            }
        },
        foundPaths: {
            enumerable: true,

            /**
             * @return {array}
             */
            get: function () {
                return this.foundDirectories.concat(this.foundFiles);
            }
        },
        visitedPaths: {
            enumerable: true,

            /**
             * @return {array}
             */
            get: function () {
                return this.visitedDirectories.concat(this.visitedFiles);
            }
        }
    });
};
ScanningResult.prototype = Object.create(Task.prototype);

/**
 * @return {void}
 */
ScanningResult.prototype.notifyDone = function () {
    Task.prototype.notifyDone.call(this, this);
};

/**
 * @return {void}
 */
ScanningResult.prototype.notifyFail = function () {
    Task.prototype.notifyFail.call(this, this);
};

/**
 * @return {void}
 */
ScanningResult.prototype.notifyStart = function () {
    Task.prototype.notifyStart.call(this, this);
};

/**
 * @return {void}
 */
ScanningResult.prototype.notifyStop = function () {
    Task.prototype.notifyStop.call(this, this);
};

module.exports = ScanningResult;
