/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var Configuration = require("configuration-processor").Configuration,
    SCANNER_DEFAULT_PATTERN = (/.*/),
    ScanningConfiguration; // constructor, function

/**
 * @auguments configuration-processor/Configuration
 * @constructor
 * @param {object} [options]
 */
ScanningConfiguration = function (options) {
    Configuration.call(this, options);
};
ScanningConfiguration.prototype = Object.create(Configuration.prototype);

/**
 * @return {object}
 */
ScanningConfiguration.prototype.expect = function () {
    return this.expectSchema({
        isLookingForDirectory: this.expectBooleanDefault(true),
        isLookingForFile: this.expectBooleanDefault(true),
        limit: this.expectIntDefault(0),
        pattern: this.expectGroupOrDefault([
            this.expectRegExp(),
            this.expectString()
        ], SCANNER_DEFAULT_PATTERN)
    });
};

module.exports = ScanningConfiguration;
