/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var ScanningConfiguration = require(__dirname + "/ScanningConfiguration"),
    ScanningBranchAggregator, // constructor, function
    ScanningBranch = require(__dirname + "/ScanningBranch"),
    TaskAggregator = require("flow-inspector").TaskAggregator,
    concat; // private, function

/**
 * @access private
 * @param {JsLoader/FileSystem/ScanningBranchAggregator} scanningBranchRepository
 * @param {string} property
 * @return {array}
 */
concat = function (scanningBranchRepository, property) {
    var i,
        ret = [];

    for (i = 0; i < scanningBranchRepository.list.length; i += 1) {
        ret = ret.concat(scanningBranchRepository.list[i][property]);
    }

    return ret;
};

/**
 * @auguments flow-inspector/TaskAggregator
 * @constructor
 * @param {object} [options]
 */
ScanningBranchAggregator = function (options) {
    TaskAggregator.call(this);

    this.options = new ScanningConfiguration(options);
};
ScanningBranchAggregator.prototype = Object.create(TaskAggregator.prototype);

Object.defineProperties(ScanningBranchAggregator.prototype, {
    foundDirectories: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "foundDirectories");
        }
    },
    foundFiles: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "foundFiles");
        }
    },
    foundPaths: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "foundPaths");
        }
    },
    visitedDirectories: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "visitedDirectories");
        }
    },
    visitedFiles: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "visitedFiles");
        }
    },
    visitedPaths: {
        enumerable: true,

        /**
         * @return {void}
         */
        get: function () {
            return concat(this, "visitedPaths");
        }
    }
});

/**
 * @param {JsLoader/FileSystem/ScanningBranch} scanningBranch
 * @return {void}
 */
ScanningBranchAggregator.prototype.isItemAllowed = function (scanningBranch) {
    return scanningBranch instanceof ScanningBranch;
};

module.exports = ScanningBranchAggregator;
