/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var ScanningConfiguration = require(__dirname + "/ScanningConfiguration"),
    ScanningBranch, // constructor, function
    ScanningResult = require(__dirname + "/ScanningResult"),
    config = require("configuration-processor").configurationProcessor,
    p = require("path");

/**
 * @auguments JsLoader/FileSystem/ScanningResult
 * @constructor
 * @param {object} [options]
 */
ScanningBranch = function (options) {
    ScanningResult.call(this);

    this.options = new ScanningConfiguration(options);
};
ScanningBranch.prototype = Object.create(ScanningResult.prototype);

/**
 * @param {string} path
 * @return {bool}
 */
ScanningBranch.prototype.coversPath = function (path) {
    var i,
        longestVisitedPath,
        visitedPaths = this.visitedPaths.sort();

    path = config.assertString(path);
    for (i = 0; i < visitedPaths.length; i += 1) {
        if (path === visitedPaths[i]) {
            return true;
        }

        if (0 !== path.indexOf(visitedPaths[i])) {
            return false;
        }
    }

    path = path.split(p.sep);
    longestVisitedPath = visitedPaths.pop().split(p.sep);

    return path.length > longestVisitedPath.length;
};

module.exports = ScanningBranch;
