/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

var Asynchronous, // constructor, function
    FileSystemStrategy = require(__dirname + "/../FileSystemStrategy"),
    fs = require("fs");

/**
 * @auguments JsLoader/FileSystem/FileSystemStrategy
 * @constructor
 */
Asynchronous = function () {
    FileSystemStrategy.call(this);
};
Asynchronous.prototype = Object.create(FileSystemStrategy.prototype);

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy~existsCallback} callback
 * @return {void}
 */
Asynchronous.prototype.exists = function (path, callback) {
    fs.exists(path, function (exists) {
        callback(exists);
    });
};

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy~readDirCallback} callback
 * @return {void}
 */
Asynchronous.prototype.readDir = function (path, callback) {
    fs.readdir(path, function (err, files) {
        callback(files, err);
    });
};

/**
 * @param {string} path
 * @param {object} options
 * @param {JsLoader/FileSystem/FileSystemStrategy~readFileCallback} callback
 * @return {void}
 */
Asynchronous.prototype.readFile = function (path, options, callback) {
    fs.readFile(path, options, function (err, content) {
        callback(content, err);
    });
};

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy~realpathCallback} callback
 * @return {void}
 * @throws {Error}
 */
Asynchronous.prototype.realpath = function (path, callback) {
    fs.realpath(path, function (err, realpath) {
        callback(realpath, err);
    });
};

/**
 * @param {string} path
 * @param {JsLoader/FileSystem/FileSystemStrategy~statCallback} callback
 * @return {void}
 */
Asynchronous.prototype.stat = function (path, callback) {
    fs.stat(path, function (err, stat) {
        callback(stat, err);
    });
};

module.exports = Asynchronous;
