/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    Event = require(global.MODULE_ROOT + "/libraries/scripts/Bender/EventDispatcher/Event");

describe("Bender/EventDispatcher/Event", function () {
    it("does not allow anything but object as data", function () {
        var evt;

        assert.throws(function () {
            evt = new Event("hello");
        }, Error);
    });

    it("allows accessing internal event data", function () {
        var data1 = "bar",
            data2 = "booz",
            evt = new Event({
                key1: data1,
                key2: data2
            });

        assert.equal(evt.key1, data1);
        assert.equal(evt.key2, data2);
    });

    describe("#stopPropagation", function () {
        it("stops propagation", function () {
            var evt = new Event();

            assert.ok(!evt.isPropagationStopped);

            evt.stopPropagation();

            assert.ok(evt.isPropagationStopped);
        });
    });
});
