/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/configuration-processor",
            "data-container/Node/LinkedList"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require("configuration-processor"),
            require("data-container").LinkedListNode
        ]);
    }

}(function (configurationProcessor, LinkedListNode) {

    var config = configurationProcessor.configurationProcessor,
        ListenerLinkedListNode; // constructor, function

    /**
     * @auguments data-container/LinkedListNode
     * @constructor
     * @param {Bender/EventDispatcher/Listener} listener
     */
    ListenerLinkedListNode = function (listener) {
        var priority;

        LinkedListNode.call(this, listener);

        Object.defineProperty(this, "priority", {
            /**
             * @return {number}
             */
            get: function () {
                return priority;
            },

            /**
             * @param {number} value
             * @return {void}
             */
            set: function (value) {
                priority = config.assertInt(value);
            }
        });
    };
    ListenerLinkedListNode.prototype = Object.create(LinkedListNode.prototype);

    /**
     * @param {function} item
     * @return {bool}
     */
    ListenerLinkedListNode.prototype.isItemAllowed = function (item) {
        return "function" === typeof item;
    };

    /**
     * @param {Bender/EventDispatcher/ListenerLinkedListNode|void} item
     * @return {bool}
     */
    ListenerLinkedListNode.prototype.isSiblingAllowed = function (item) {
        return !item || (item instanceof ListenerLinkedListNode);
    };

    return ListenerLinkedListNode;

}));
