/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "data-container/Repository/LinkedList",
            "event-dispatcher/ListenerLinkedListNode"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require("data-container").LinkedList,
            require(__dirname + "/ListenerLinkedListNode")
        ]);
    }

}(function (LinkedList, ListenerLinkedListNode) {

    var ListenerLinkedList; // constructor, function

    /**
     * @auguments data-container/LinkedList
     * @constructor
     * @param {array} [listeners] initial listeners collection
     */
    ListenerLinkedList = function (listeners) {
        LinkedList.call(this, listeners);
    };
    ListenerLinkedList.prototype = Object.create(LinkedList.prototype);

    /**
     * @param {Bender/EventDispatcher/ListenerLinkedListNode} item
     * @return {bool}
     */
    ListenerLinkedList.prototype.canDecapsulate = function (item) {
        return item instanceof ListenerLinkedListNode;
    };

    /**
     * @param {Bender/EventDispatcher/ListenerLinkedListNode} item
     * @return {mixed}
     * @throws {Error} if item cannot be decapsulated
     */
    ListenerLinkedList.prototype.decapsulateItem = function (item) {
        if (!this.canDecapsulate(item)) {
            throw new Error("Item cannot be decapsulated: " + item);
        }

        return item.value;
    };

    /**
     * @param {mixed} item
     * @return {Bender/EventDispatcher/ListenerLinkedListNode}
     */
    ListenerLinkedList.prototype.encapsulateItem = function (item) {
        return new ListenerLinkedListNode(item);
    };

    /**
     * @param {Bender/EventDispatcher/ListenerLinkedListNode} listenerLinkedListNode
     * @return {bool}
     */
    ListenerLinkedList.prototype.isItemAllowed = function (listenerLinkedListNode) {
        return listenerLinkedListNode instanceof ListenerLinkedListNode;
    };

    return ListenerLinkedList;

}));
