/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "event-dispatcher/EventDispatcher",
            "event-dispatcher/EventDispatcherRepository"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../EventDispatcher"),
            require(__dirname + "/../EventDispatcherRepository")
        ]);
    }

}(function (EventDispatcher, EventDispatcherRepository) {

    var EventAggregator; // constructor, function

    /**
     * @auguments Bender/EventDispatcher/EventDispatcherRepository
     * @borrows EventDispatcher.prototype.isEventSupported as isEventSupported
     * @constructor
     */
    EventAggregator = function () {
        EventDispatcherRepository.call(this);
    };
    EventAggregator.prototype = Object.create(EventDispatcherRepository.prototype);

    /**
     * @type {function}
     */
    EventAggregator.prototype.isEventSupported = EventDispatcher.prototype.isEventSupported;

    /**
     * @param {string} eventName
     * @param {function} listener
     * @return {void}
     */
    EventAggregator.prototype.addListener = function (eventName, listener) {
        var eventDispatcher,
            eventDispatchers = this.list,
            i;

        for (i = 0; i < eventDispatchers.length; i += 1) {
            eventDispatcher = eventDispatchers[i];
            if (eventDispatcher.isEventSupported(eventName) && !eventDispatcher.hasListener(eventName, listener)) {
                eventDispatcher.addListener(eventName, listener);
            }
        }
    };

    /**
     * @return {array}
     */
    EventAggregator.prototype.getSupportedEvents = function () {
        var i,
            j,
            ret = {},
            supportedEvents;

        for (i = 0; i < this.list.length; i += 1) {
            supportedEvents = this.list[i].getSupportedEvents();
            for (j = 0; j < supportedEvents.length; j += 1) {
                ret[supportedEvents[j]] = true;
            }
        }

        return Object.keys(ret);
    };

    return EventAggregator;

}));
