/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define(factory);
    } else {
        module.exports = factory.call(null);
    }

}(function () {

    var Event; // constructor, function

    /**
     * @constructor
     * @param {object} data (optional)
     */
    Event = function (data) {
        if (data) {
            this.setData(data);
        }

        this.isPropagationStopped = false;
    };

    /**
     * @param {object} data
     * @return {void}
     * @throws {Error} if data argument is invalid
     */
    Event.prototype.setData = function (data) {
        var property;

        if ("object" !== typeof data) {
            throw new Error("Event data is not an object.");
        }

        for (property in data) {
            if (data.hasOwnProperty(property)) {
                this[property] = data[property];
            }
        }
    };

    /**
     * @return {void}
     */
    Event.prototype.stopPropagation = function () {
        this.isPropagationStopped = true;
    };

    return Event;

}));
