/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    LinkedListNode = require(global.MODULE_ROOT + "/libraries/scripts/Bender/DataContainer/Node/LinkedList");

describe("Bender/DataContainer/Node/LinkedList", function () {
    var Bar, // constructor, function
        Foo; // constructor, function

    /**
     * @constructor
     */
    Bar = function () {};

    /**
     * @constructor
     */
    Foo = function () {};

    describe("#value", function () {
        var TestDipper; // private, function

        TestDipper = function (item) {
            LinkedListNode.call(this, item);
        };
        TestDipper.prototype = Object.create(LinkedListNode.prototype);

        /**
         * @param {mixed} item
         * @return {mixed} encapsulated item
         */
        TestDipper.prototype.encapsulateItem = function (item) {
            return new Foo(item);
        };

        it("adds item into container and wraps it with predefined class", function () {
            var linkedListNode,
                raw = new Bar();

            linkedListNode = new TestDipper(raw);
            assert.ok(linkedListNode.value instanceof Foo);
        });

        it("can reject some values", function () {
            var linkedListNode = new LinkedListNode();

            linkedListNode.isItemAllowed = function (item) {
                return item > 5;
            };

            linkedListNode.value = 6;
            assert.throws(function () {
                linkedListNode.value = 5;
            });
        });
    });

    describe("#valueOf", function () {
        it("returns the same thing as #value", function () {
            var linkedListNode = new LinkedListNode(4);

            assert.strictEqual(linkedListNode.value, linkedListNode.valueOf());
        });
    });
});
