/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    GraphNode = require(global.MODULE_ROOT + "/libraries/scripts/Bender/DataContainer/Node/Graph"),
    GraphVertex = require(global.MODULE_ROOT + "/libraries/scripts/Bender/DataContainer/GraphVertex"),
    GraphVertexMap = require(global.MODULE_ROOT + "/libraries/scripts/Bender/DataContainer/Map/GraphVertex");

describe("Bender/DataContainer/Node/Graph", function () {
    var createGraphNode; // private, function

    /**
     * @return {Bender/DataContainer}
     */
    createGraphNode = function () {
        var predecessors = new GraphVertexMap(),
            successors = new GraphVertexMap();

        return new GraphNode(new GraphVertex(), predecessors, successors);
    };

    describe("#next", function () {
        it("can reject some values", function () {
            var graphNode = createGraphNode();

            assert.throws(function () {
                graphNode.next = void 0;
            });
        });
    });

    describe("#removeSibling", function () {
        it("fails when node does not contain sibling vertex", function () {
            var graphNode = createGraphNode();

            assert.throws(function () {
                graphNode.removeSibling(1);
            });
        });

        it("removes sibling both from graps predecessors and successors", function () {
            var graphNode = createGraphNode();

            graphNode.next.add(1);
            graphNode.prev.add(1);

            graphNode.removeSibling(1);

            assert.ok(!graphNode.next.has(1));
            assert.ok(!graphNode.prev.has(1));
        });

        it("removes sibling from graps predecessors", function () {
            var graphNode = createGraphNode();

            graphNode.prev.add(1);
            graphNode.removeSibling(1);

            assert.ok(!graphNode.prev.has(1));
        });

        it("removes sibling from graps successors", function () {
            var graphNode = createGraphNode();

            graphNode.next.add(1);
            graphNode.removeSibling(1);

            assert.ok(!graphNode.next.has(1));
        });
    });

    describe("#value", function () {
        it("can reject some values", function () {
            var graphNode;

            assert.throws(function () {
                graphNode = new GraphNode();
            });
        });
    });
});
