/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "data-container/Node"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../Node")
        ]);
    }

}(function (Node) {

    var LinkedListNode; // constructor, function

    /**
     * @auguments Bender/DataContainer/Node
     * @constructor
     * @param {mixed} value
     */
    LinkedListNode = function (value) {
        Node.call(this, value);
    };
    LinkedListNode.prototype = Object.create(Node.prototype);

    /**
     * @param {Bender/DataContainer/Node/LinkedList|void} item
     * @return {bool}
     */
    LinkedListNode.prototype.isSiblingAllowed = function (item) {
        return !item || (item instanceof LinkedListNode);
    };

    return LinkedListNode;

}));
