/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define(factory);
    } else {
        module.exports = factory.call(null);
    }

}(function () {

    var Node, // constructor, function
        defineSiblingProperty; // private, function

    /**
     * @param {Bender/DataContainer/Node} node
     * @param {string} name
     * @return {void}
     */
    defineSiblingProperty = function (node, name) {
        var property;

        Object.defineProperty(node, name, {
            /**
             * @return {Bender/DataContainer/Node|void}
             */
            get: function () {
                return property;
            },

            /**
             * @param {Bender/DataContainer/Node|void} item
             */
            set: function (item) {
                item = this.encapsulateSibling(item);
                if (!this.isSiblingAllowed(item)) {
                    throw new Error("Node does not allow given value: " + item);
                }

                property = item;
            }
        });
    };

    /**
     * @constructor
     * @param {mixed} value
     */
    Node = function (value) {
        defineSiblingProperty(this, "next");
        defineSiblingProperty(this, "previous");

        Object.defineProperty(this, "value", {
            configurable: true,
            enumerable: true,

            /**
             * @return {Bender/DataContainer/Node|void}
             */
            get: function () {
                return value;
            },

            /**
             * @param {mixed} item
             */
            set: function (item) {
                item = this.encapsulateItem(item);
                if (!this.isItemAllowed(item)) {
                    throw new Error("Node does not allow given value: " + item);
                }

                value = item;
            }
        });

        this.value = value;
    };

    /**
     * @param {mixed} item
     * @return {mixed}
     */
    Node.prototype.encapsulateItem = function (item) {
        return item;
    };

    /**
     * @param {mixed} sibling
     * @return {mixed}
     */
    Node.prototype.encapsulateSibling = function (sibling) {
        return sibling;
    };

    /**
     * @param {mixed} item
     * @return {bool}
     */
    Node.prototype.isItemAllowed = function (item) {
        return true;
    };

    /**
     * @param {mixed} item
     * @return {bool}
     */
    Node.prototype.isSiblingAllowed = function (item) {
        return true;
    };

    /**
     * @return {mixed}
     */
    Node.prototype.valueOf = function () {
        return this.value;
    };

    return Node;

}));
