/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define(factory);
    } else {
        module.exports = factory.call(null);
    }

}(function () {

    var GraphVertex; // constructor, function

    /**
     * @constructor
     * @param {mixed} value
     */
    GraphVertex = function (value) {
        Object.defineProperty(this, "value", {
            /**
             * @return {Bender/DataContainer/Node|void}
             */
            get: function () {
                return value;
            },

            /**
             * @param {mixed} item
             */
            set: function (item) {
                if (!this.isItemAllowed(item)) {
                    throw new Error("Value cannot be used as graph vertex: " + item);
                }

                value = item;
            }
        });

        this.value = value;
    };

    /**
     * @param {mixed} item
     * @return {bool}
     */
    GraphVertex.prototype.isItemAllowed = function (item) {
        return true;
    };

    return GraphVertex;

}));
