/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var AssertionFailure = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/ConfigurationProcessor/Error/AssertionFailure"),
    assert = require("assert");

describe("JsLoader/ConfigurationProcessor/Error/AssertionFailure", function () {

    describe("#decorateMessage", function () {

        it("decorates boolean", function () {
            var assertionFailureError = new AssertionFailure();

            assert.ok(assertionFailureError.decorateMessage("test", true));
        });

        it("decorates null object", function () {
            var assertionFailureError = new AssertionFailure();

            assert.ok(assertionFailureError.decorateMessage("test", null));
        });

        it("decorates number", function () {
            var assertionFailureError = new AssertionFailure();

            assert.ok(assertionFailureError.decorateMessage("test", 1));
        });

        it("decorates object", function () {
            var assertionFailureError = new AssertionFailure();

            assert.ok(assertionFailureError.decorateMessage("test", {}));
        });

    });

    describe("#stack", function () {

        it("generates full stack trace", function () {
            var assertionFailureError = new AssertionFailure();

            assert.ok(assertionFailureError.stack);
        });

    });

});
