/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var AssertionFailure = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/ConfigurationProcessor/Error/AssertionFailure"),
    Configuration = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/ConfigurationProcessor/Configuration"),
    assert = require("assert");

describe("JsLoader/ConfigurationProcessor/Configuration", function () {
    describe("#expect", function () {
        describe("JsLoader/ConfigurationProcessor/ConfigurationProcessor#expectConfiguration", function () {
            var TestConfig1,
                TestConfig2;

            TestConfig1 = function (options) {
                Configuration.call(this, options);
            };
            TestConfig1.prototype = Object.create(Configuration.prototype);
            TestConfig1.prototype.expect = function () {
                return this.expectGroup([
                    this.expectEmpty(),
                    this.expectString()
                ]);
            };

            TestConfig2 = function (options) {
                Configuration.call(this, options);
            };
            TestConfig2.prototype = Object.create(Configuration.prototype);
            TestConfig2.prototype.expect = function () {
                return this.expectMap(this.expectConfiguration(TestConfig1));
            };

            it("allows configuration embedding", function () {
                var input,
                    testConfig2;

                input = {
                    testKey1: "",
                    testKey2: ""
                };
                testConfig2 = new TestConfig2(input);

                assert.deepEqual(input, testConfig2);
            });

            it("fails on invalid embedded configuration", function () {
                var testConfig2;

                assert.throws(function () {
                    testConfig2 = new TestConfig2({
                        test: "not-an-empty-string"
                    });
                }, AssertionFailure);
            });
        });
        it("allows empty configuration", function () {
            var config = new Configuration();

            assert.equal(Object.keys(config).length, 0);
        });
        it("passess all configuration values to Configuration object", function () {
            var config;

            config = new Configuration({
                hello: "world"
            });

            assert.equal(config.hello, "world");
        });
        it("validates configuration instantly against a schema", function () {
            var TestConfig,
                testConfig;

            TestConfig = function (options) {
                Configuration.call(this, options);
            };
            TestConfig.prototype = Object.create(Configuration.prototype);

            TestConfig.prototype.expect = function () {
                return this.expectSchema({
                    hello: this.expectStringDefault("world")
                });
            };

            assert.throws(function () {
                testConfig = new TestConfig({
                    hello: 123
                });
            }, AssertionFailure);
        });
    });

    describe("#updateConfiguration", function () {
        it("validates configuration against a schema", function () {
            var config;

            config = new Configuration();
            config.expect = function () {
                return this.expectSchema({
                    hello: this.expectStringDefault("world")
                });
            };

            assert.throws(function () {
                config.updateConfiguration({
                    hello: 123
                });
            });
        });
        it("removes previous configuration", function () {
            var config;

            config = new Configuration({
                hello: 123
            });

            config.updateConfiguration({
                world: 456
            });

            assert.ok(!config.hello);
            assert.strictEqual(config.world, 456);
        });
    });
});
