/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global describe: false, it: false */

var assert = require("assert"),
    Configuration = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/ConfigurationProcessor/Configuration"),
    ConfigurationConverter = require(global.MODULE_ROOT + "/libraries/scripts/JsLoader/ConfigurationProcessor/ConfigurationConverter");

describe("JsLoader/ConfigurationProcessor/ConfigurationConverter", function () {
    describe("#formatOutputConfiguration", function () {
        var ConfigurationSource,
            ConfigurationTarget;

        ConfigurationSource = function (options) {
            Configuration.call(this, options);
        };
        ConfigurationSource.prototype = Object.create(Configuration.prototype);
        ConfigurationSource.prototype.expect = function () {
            return this.expectMap(this.expectString());
        };

        ConfigurationTarget = function (options) {
            Configuration.call(this, options);
        };
        ConfigurationTarget.prototype = Object.create(Configuration.prototype);
        ConfigurationTarget.prototype.expect = function () {
            return this.expectArrayEach(this.expectSchema({
                name: this.expectString(),
                value: this.expectString()
            }));
        };

        it("converts between configuration formats", function () {
            var configurationConverter = new ConfigurationConverter(ConfigurationSource, ConfigurationTarget),
                expectedOutput,
                input;

            expectedOutput = [{
                "name": "key1",
                "value": "value1"
            }, {
                "name": "key2",
                "value": "value2"
            }, {
                "name": "key3",
                "value": "value3"
            }];

            input = {
                "key1": "value1",
                "key2": "value2",
                "key3": "value3"
            };

            configurationConverter.formatOutputConfiguration = function (options) {
                var name,
                    ret = [];

                for (name in options) {
                    if (options.hasOwnProperty(name)) {
                        ret.push({
                            name: name,
                            value: options[name]
                        });
                    }
                }

                return ret;
            };

            assert.deepEqual(configurationConverter.convert(input), expectedOutput);
        });
    });
});
