/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/Error/AssertionFailure"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../AssertionFailure")
        ]);
    }

}(function (AssertionFailure) {

    var Traceable;

    /**
     * @auguments JsLoader/Configuration/Error/AssertionFailure
     * @constructor
     * @param {string} message
     * @param {mixed} item item that caused the error
     * @param {array} trace
     */
    Traceable = function (message, item, trace) {
        AssertionFailure.call(this, message, item);

        this.trace = trace;
    };
    Traceable.prototype = Object.create(AssertionFailure.prototype);
    Traceable.prototype.name = "AssertionFailureTraceableError";

    /**
     * @param {string} message
     * @param {mixed} item item that caused the error
     * @return {string}
     */
    Traceable.prototype.decorateMessage = function (message, item) {
        return message + ' at "' + this.trace.join('.') + '"';
    };

    return Traceable;

}));
