/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/Error/AssertionFailure"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../AssertionFailure")
        ]);
    }

}(function (AssertionFailure) {

    var Aggregated;

    /**
     * @auguments JsLoader/Configuration/Error/AssertionFailure
     * @constructor
     * @param {string} message
     * @param {mixed} item item that caused the error
     */
    Aggregated = function (message, item) {
        AssertionFailure.call(this, message, item);

        this.errors = [];
    };
    Aggregated.prototype = Object.create(AssertionFailure.prototype);
    Aggregated.prototype.name = "AssertionFailureAggregatedError";

    /**
     * @param {mixed} err
     * @return {void}
     */
    Aggregated.prototype.add = function (err) {
        this.errors.push(err);
    };

    return Aggregated;

}));
