/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define(factory);
    } else {
        module.exports = factory.call(null);
    }

}(function () {

    var AssertionFailure,
        STACK_SPLIT_PATTERN = "\n",
        decorateItemDump, // private, function
        dumpItem; // private, function

    /**
     * @access private
     * @param {mixed} item
     * @param {string} dump
     * @return {string}
     */
    decorateItemDump = function (item, dump) {
        var type = typeof item;

        if (dump) {
            return '(' + type + ')"' + dump + '"';
        }

        return type;
    };

    /**
     * @access private
     * @param {mixed} item
     * @return {string}
     */
    dumpItem = function (item) {
        switch (typeof item) {
        case "boolean":
        case "number":
            return decorateItemDump(item, "" + item);
        case "object":
        case "function":
            if (null === item) {
                return decorateItemDump(item, "null");
            }

            return decorateItemDump(item, item.toString());
        case "string":
            return decorateItemDump(item, item);
        }

        return decorateItemDump(item);
    };

    /**
     * @borrows Error.prototype.toString as toString
     * @constructor
     * @param {string} message
     * @param {mixed} item item that caused the error
     */
    AssertionFailure = function (message, item) {
        var stack = (new Error()).stack;

        Object.defineProperty(this, "message", {

            enumerable: true,

            /**
             * @return {string}
             */
            get: function () {
                return this.decorateMessage(message, item);
            }

        });

        Object.defineProperty(this, "stack", {

            enumerable: true,

            /**
             * @return {string}
             */
            get: function () {
                // this is very node.js specific solution for displaying sort of
                // accurate stack trace and may not work on other platforms
                stack = stack.split(STACK_SPLIT_PATTERN);

                stack.shift(); // previous error message
                while (-1 !== stack[0].indexOf(__filename)) {
                    // clear stack from redundant function calls information
                    stack.shift();
                }

                stack.unshift(this.toString());

                return stack.join(STACK_SPLIT_PATTERN);
            }

        });
    };
    AssertionFailure.prototype.name = "AssertionFailureError";
    AssertionFailure.prototype.toString = Error.prototype.toString;

    /**
     * @param {string} message
     * @param {mixed} item item that caused the error
     * @return {string}
     */
    AssertionFailure.prototype.decorateMessage = function (message, item) {
        return message + ": " + dumpItem(item) + " given";
    };

    return AssertionFailure;

}));
