/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/configurationProcessor",
            "configuration-processor/Configuration"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../../../modules/configuration-processor").configurationProcessor,
            require(__dirname + "/Configuration")
        ]);
    }

}(function (config, Configuration) {

    var ConfigurationConverter; // constructor, function

    /**
     * @abstract
     * @constructor
     * @param {JsLoader/ConfigurationProcessor/Configuration} Source not instanciated configuration object
     * @param {JsLoader/ConfigurationProcessor/Configuration} Target not instanciated configuration object
     */
    ConfigurationConverter = function (Source, Target) {
        this.Source = this.assertSupportedSource(Source);
        this.Target = this.assertSupportedTarget(Target);
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/Configuration} Source
     * @return {JsLoader/ConfigurationProcessor/Configuration}
     */
    ConfigurationConverter.prototype.assertSupportedSource = function (Source) {
        return config.assertChildOf(this.getSupportedSource(), Source);
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/Configuration} Target
     * @return {JsLoader/ConfigurationProcessor/Configuration}
     */
    ConfigurationConverter.prototype.assertSupportedTarget = function (Target) {
        return config.assertChildOf(this.getSupportedTarget(), Target);
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/Configuration} options
     * @return {JsLoader/ConfigurationProcessor/Configuration}
     */
    ConfigurationConverter.prototype.convert = function (options) {
        options = new this.Source(options);

        return new this.Target(this.formatOutputConfiguration(options));
    };

    /**
     * @abstract
     * @param {mixed} options
     * @return {object}
     */
    ConfigurationConverter.prototype.formatOutputConfiguration = function (options) {
        return options;
    };

    /**
     * @return {JsLoader/ConfigurationProcessor/Configuration}
     */
    ConfigurationConverter.prototype.getSupportedSource = function () {
        return Configuration;
    };

    /**
     * @return {JsLoader/ConfigurationProcessor/Configuration}
     */
    ConfigurationConverter.prototype.getSupportedTarget = function () {
        return Configuration;
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/Configuration} Source
     * @return {bool}
     */
    // ConfigurationConverter.prototype.isSourceSupported = function (Source) {
    //     return Source instanceof this.getSupportedSource().prototype;
    // };

    /**
     * @param {JsLoader/ConfigurationProcessor/Configuration} Target
     * @return {bool}
     */
    // ConfigurationConverter.prototype.isTargetSupported = function (Target) {
    //     return Target instanceof this.getSupportedTarget().prototype;
    // };

    return ConfigurationConverter;

}));
