/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/ConfigurationProcessor"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/ConfigurationProcessor")
        ]);
    }

}(function (ConfigurationProcessor) {

    var Configuration, // constructor, function
        expectAnything; // private, function

    /**
     * @access private
     * @param {JsLoader/ConfigurationProcessor/Configuration} config
     * @param {mixed} options
     * @return {mixed}
     */
    expectAnything = function (config, options) {
        // just do nothing by default
        return options;
    };

    /**
     * This is the base abstract class for implementing reusable configuration
     * objects.
     *
     * @abstract
     * @auguments JsLoader/ConfigurationProcessor/ConfigurationProcessor
     * @constructor
     */
    Configuration = function (options) {
        ConfigurationProcessor.call(this);

        this.updateConfiguration(options);
    };
    Configuration.prototype = Object.create(ConfigurationProcessor.prototype);

    /**
     * @abstract
     * @param {mixed} item
     * @return {function}
     */
    Configuration.prototype.assert = function (item) {
        return this.expect()(item);
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/ConfigurationProcessor} Configuration
     * @param {mixed} item
     * @return {mixed}
     * @throws {JsLoader/ConfigurationProcessor/Error/AssertionFailure}
     */
    ConfigurationProcessor.prototype.assertConfiguration = function (Configuration, item) {
        return new Configuration(item);
    };

    /**
     * @abstract
     * @return {function}
     */
    Configuration.prototype.expect = function () {
        return expectAnything.bind(null, this);
    };

    /**
     * @param {JsLoader/ConfigurationProcessor/ConfigurationProcessor} Configuration
     * @return {function}
     */
    ConfigurationProcessor.prototype.expectConfiguration = function (Configuration) {
        return this.assertConfiguration.bind(this, Configuration);
    };

    /**
     * @param {object} [options]
     * @return {void}
     */
    Configuration.prototype.updateConfiguration = function (options) {
        var property;

        options = this.assert(options);

        for (property in this) {
            if (this.hasOwnProperty(property)) {
                delete this[property];
            }
        }

        for (property in options) {
            if (options.hasOwnProperty(property)) {
                this[property] = options[property];
            }
        }
    };

    return Configuration;

}));
