/**
 * @license Copyright (c) 2013, CKSource - Frederico Knabben
 * For licensing, see LICENSE
 */

"use strict";

/* global define: false */

(function (factory) {

    if ("function" === typeof define) {
        define([
            "configuration-processor/Error/AssertionFailure",
            "configuration-processor/Configuration",
            "configuration-processor/ConfigurationProcessor"
        ], factory);
    } else {
        module.exports = factory.apply(null, [
            require(__dirname + "/../scripts/JsLoader/ConfigurationProcessor/Error/AssertionFailure"),
            require(__dirname + "/../scripts/JsLoader/ConfigurationProcessor/Configuration"),
            require(__dirname + "/../scripts/JsLoader/ConfigurationProcessor/ConfigurationProcessor")
        ]);
    }

}(function (AssertionFailureError, Configuration, ConfigurationProcessor) {

    return {
        AssertionFailureError: AssertionFailureError,
        Configuration: Configuration,
        ConfigurationProcessor: ConfigurationProcessor,
        configurationProcessor: new ConfigurationProcessor()
    };

}));
