# Configuration Processor

Configuration processor asserts that input configuration matches predefined
configuration schema.

It also provides some basic assertion tools.

## Examples

### Testing input agains predefined schema

```JavaScript
var config = require("configuration-processor"),
    input,
    processed;

input = {
    key1: "key1_value",
    key2: {
        key2n1: false
    }
};

processed = config.assertSchema({
    key1: config.expectStringRegExp(/_value$/),
    key2: config.expectSchema({
        key2n1: config.expectBoolean(),
        key2n2: config.expectBooleanDefault(true)
    })
}, input);
```

Processed configuration looks like so:

```JavaScript
{
    key1: "key1_value",
    key2: {
        key2n1: false,
        key2n2: true
    }
}
```
