var express = require("express");
const UserLoanController = require("../controllers/UserLoanController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", UserLoanController.userLoanList,utility.unAuth);
router.get("/user/", UserLoanController.userSpecificLoanList,utility.unAuth);
router.get("/my-loan/", UserLoanController.myLoanList,utility.unAuth);
router.get("/all/", UserLoanController.allUserLoanList,utility.unAuth);
router.get("/:id", UserLoanController.userLoanDetail,utility.unAuth);
router.post("/", UserLoanController.userLoanStore,utility.unAuth);
router.put("/:id", UserLoanController.userLoanUpdate,utility.unAuth);
router.delete("/:id", UserLoanController.userLoanDelete,utility.unAuth);
router.post("/bulk-delete", UserLoanController.userLoanBulkDelete, utility.unAuth);
router.put("/approval/:id", UserLoanController.loanApproval, utility.unAuth);

module.exports = router;